/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl;

import com.hazelcast.hotrestart.HotRestartException;
import com.hazelcast.internal.hotrestart.HotRestartKey;
import com.hazelcast.internal.hotrestart.HotRestartStore;
import com.hazelcast.internal.hotrestart.impl.HotRestartPersistenceEngine;
import com.hazelcast.internal.hotrestart.impl.HotRestarter;
import com.hazelcast.internal.hotrestart.impl.RestartItem;
import com.hazelcast.internal.hotrestart.impl.RunnableWithStatus;
import com.hazelcast.internal.hotrestart.impl.di.DiContainer;
import com.hazelcast.internal.hotrestart.impl.di.Inject;
import com.hazelcast.internal.hotrestart.impl.di.Name;
import com.hazelcast.internal.hotrestart.impl.gc.BackupExecutor;
import com.hazelcast.internal.hotrestart.impl.gc.GcLogger;
import com.hazelcast.internal.hotrestart.impl.gc.Rebuilder;
import com.hazelcast.internal.util.concurrent.BackoffIdleStrategy;
import com.hazelcast.internal.util.concurrent.ConcurrentConveyor;
import com.hazelcast.internal.util.concurrent.ConcurrentConveyorSingleQueue;
import com.hazelcast.internal.util.concurrent.IdleStrategy;
import com.hazelcast.persistence.BackupTaskState;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;

public final class ConcurrentHotRestartStore
implements HotRestartStore {
    public static final int MUTATOR_QUEUE_CAPACITY = 1024;
    private static final IdleStrategy IDLER = new BackoffIdleStrategy(1L, 1L, 1L, TimeUnit.MICROSECONDS.toNanos(200L));
    private final String name;
    private final HotRestartPersistenceEngine persistence;
    private final ConcurrentConveyorSingleQueue<RunnableWithStatus> persistenceConveyor;
    private final DiContainer di;
    private final PersistenceEngineLoop persistenceLoop;
    private final Thread persistenceThread;
    private final GcLogger logger;
    private final BackupExecutor backupExecutor;

    @Inject
    private ConcurrentHotRestartStore(GcLogger logger, @Name(value="storeName") String storeName, HotRestartPersistenceEngine persistence, @Name(value="persistenceConveyor") ConcurrentConveyorSingleQueue<RunnableWithStatus> persistenceConveyor, DiContainer di, BackupExecutor backupExecutor) {
        this.logger = logger;
        this.name = storeName;
        this.persistence = persistence;
        this.persistenceConveyor = persistenceConveyor;
        this.di = di;
        this.persistenceLoop = new PersistenceEngineLoop();
        this.persistenceThread = new Thread((Runnable)this.persistenceLoop, storeName + ".persistence-engine");
        this.backupExecutor = backupExecutor;
    }

    @Override
    public void hotRestart(boolean failIfAnyData, int storeCount, ConcurrentConveyor<RestartItem>[] keyConveyors, ConcurrentConveyor<RestartItem> keyHandleConveyor, ConcurrentConveyor<RestartItem>[] valueConveyors) throws InterruptedException {
        new DiContainer(this.di).dep(Rebuilder.class).dep("storeCount", Integer.valueOf(storeCount)).dep("keyConveyors", keyConveyors).dep("keyHandleConveyor", keyHandleConveyor).dep("valueConveyors", valueConveyors).instantiate(HotRestarter.class).restart(failIfAnyData);
        this.di.invoke(this.persistence, "start");
        this.persistenceThread.start();
    }

    @Override
    public void put(HotRestartKey key, byte[] value, boolean needsFsync) {
        HotRestartPersistenceEngine hotRestartPersistenceEngine = this.persistence;
        hotRestartPersistenceEngine.getClass();
        this.submitAndProceedWhenAllowed(new HotRestartPersistenceEngine.Put(hotRestartPersistenceEngine, key, value, needsFsync));
    }

    @Override
    public void remove(HotRestartKey key, boolean needsFsync) {
        HotRestartPersistenceEngine hotRestartPersistenceEngine = this.persistence;
        hotRestartPersistenceEngine.getClass();
        this.submitAndProceedWhenAllowed(new HotRestartPersistenceEngine.Remove(hotRestartPersistenceEngine, key, needsFsync));
    }

    @Override
    public void clear(boolean needsFsync, long ... keyPrefixes) throws HotRestartException {
        HotRestartPersistenceEngine hotRestartPersistenceEngine = this.persistence;
        hotRestartPersistenceEngine.getClass();
        this.submitAndProceedWhenAllowed(new HotRestartPersistenceEngine.Clear(hotRestartPersistenceEngine, keyPrefixes, needsFsync));
    }

    @Override
    public void close() throws HotRestartException {
        this.persistenceConveyor.submit(this.persistenceLoop.askToStop);
        try {
            this.persistenceThread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new HotRestartException("Interrupted while waiting for the persistence engine to shut down", e);
        }
    }

    @Override
    public void backup(File targetDir) {
        if (!this.backupExecutor.prepareForNewTask()) {
            this.logger.fine("Another hot backup has already been run, aborting new backup");
            return;
        }
        HotRestartPersistenceEngine hotRestartPersistenceEngine = this.persistence;
        hotRestartPersistenceEngine.getClass();
        this.submitAndProceedWhenAllowed(new HotRestartPersistenceEngine.Backup(hotRestartPersistenceEngine, targetDir));
    }

    @Override
    public BackupTaskState getBackupTaskState() {
        return this.backupExecutor.getBackupTaskState();
    }

    @Override
    public void interruptBackupTask() {
        this.backupExecutor.interruptBackupTask(false);
    }

    @Override
    public void rotateMasterEncryptionKey(byte[] key) {
        HotRestartPersistenceEngine hotRestartPersistenceEngine = this.persistence;
        hotRestartPersistenceEngine.getClass();
        this.submitAndProceedWhenAllowed(new HotRestartPersistenceEngine.RotateMasterEncryptionKey(hotRestartPersistenceEngine, key));
    }

    @Override
    public String name() {
        return this.name;
    }

    public DiContainer getDi() {
        return this.di;
    }

    private void submitAndProceedWhenAllowed(RunnableWithStatus item) {
        this.persistenceConveyor.submit(item);
        long idleCount = 0L;
        while (!item.submitterCanProceed) {
            IDLER.idle(idleCount);
            if (this.persistenceConveyor.isDrainerGone() && !item.submitterCanProceed) {
                this.persistenceConveyor.checkDrainerGone();
            }
            ++idleCount;
        }
    }

    private final class PersistenceEngineLoop
    implements Runnable {
        boolean askedToStop;
        final RunnableWithStatus askToStop = new RunnableWithStatus(true){

            @Override
            public void run() {
                PersistenceEngineLoop.this.askedToStop = true;
            }
        };

        private PersistenceEngineLoop() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            ArrayList batch = new ArrayList(1024);
            ArrayList blockingTasks = new ArrayList(1024);
            ArrayList<RunnableWithStatus> nonblockingTasks = new ArrayList<RunnableWithStatus>(1024);
            long drainCount = 0L;
            long blockingItemCount = 0L;
            try {
                long idleCount = 0L;
                ConcurrentHotRestartStore.this.persistenceConveyor.drainerArrived();
                block10: while (true) {
                    Iterator iterator;
                    if (!this.askedToStop && !Thread.interrupted()) {
                        batch.clear();
                        ConcurrentHotRestartStore.this.persistenceConveyor.drainTo(batch);
                        if (batch.isEmpty()) {
                            IDLER.idle(idleCount++);
                        } else {
                            idleCount = 0L;
                        }
                        blockingTasks.clear();
                        nonblockingTasks.clear();
                        iterator = batch.iterator();
                    } else {
                        ConcurrentHotRestartStore.this.persistenceConveyor.drainerDone();
                        try {
                            ConcurrentHotRestartStore.this.persistence.close();
                        }
                        catch (Throwable e) {
                            ConcurrentHotRestartStore.this.logger.severe("Hot restart engine failed to close", e);
                        }
                        ConcurrentHotRestartStore.this.logger.fine(String.format("Drained %,d blocking items. Mean batch size was %.1f", blockingItemCount, (double)blockingItemCount / (double)drainCount));
                        return;
                    }
                    while (iterator.hasNext()) {
                        RunnableWithStatus runnableWithStatus = (RunnableWithStatus)iterator.next();
                        (runnableWithStatus.submitterCanProceed ? nonblockingTasks : blockingTasks).add(runnableWithStatus);
                    }
                    if (!blockingTasks.isEmpty()) {
                        ++drainCount;
                        blockingItemCount += (long)blockingTasks.size();
                        for (Runnable runnable : blockingTasks) {
                            runnable.run();
                        }
                        ConcurrentHotRestartStore.this.persistence.fsync();
                        for (RunnableWithStatus runnableWithStatus : blockingTasks) {
                            runnableWithStatus.submitterCanProceed = true;
                        }
                    }
                    iterator = nonblockingTasks.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block10;
                        Runnable runnable = (Runnable)iterator.next();
                        runnable.run();
                    }
                    break;
                }
            }
            catch (Throwable t) {
                try {
                    ConcurrentHotRestartStore.this.logger.warning("Something went wrong", t);
                    ConcurrentHotRestartStore.this.persistenceConveyor.drainerFailed(t);
                }
                catch (Throwable throwable) {
                    try {
                        ConcurrentHotRestartStore.this.persistence.close();
                    }
                    catch (Throwable e) {
                        ConcurrentHotRestartStore.this.logger.severe("Hot restart engine failed to close", e);
                    }
                    ConcurrentHotRestartStore.this.logger.fine(String.format("Drained %,d blocking items. Mean batch size was %.1f", blockingItemCount, (double)blockingItemCount / (double)drainCount));
                    throw throwable;
                }
                try {
                    ConcurrentHotRestartStore.this.persistence.close();
                }
                catch (Throwable e) {
                    ConcurrentHotRestartStore.this.logger.severe("Hot restart engine failed to close", e);
                }
                ConcurrentHotRestartStore.this.logger.fine(String.format("Drained %,d blocking items. Mean batch size was %.1f", blockingItemCount, (double)blockingItemCount / (double)drainCount));
                return;
            }
        }
    }
}

