/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.backup;

import com.hazelcast.cluster.Address;
import com.hazelcast.internal.hotrestart.backup.HotRestartBackupOperation;
import com.hazelcast.internal.hotrestart.backup.HotRestartBackupSerializerHook;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.transaction.impl.TargetAwareTransactionLogRecord;
import java.io.IOException;
import java.util.UUID;

public class HotRestartBackupTransactionLogRecord
implements TargetAwareTransactionLogRecord {
    private long backupSeq;
    private Address initiator;
    private Address target;
    private UUID txnId;
    private long leaseTime;

    public HotRestartBackupTransactionLogRecord() {
    }

    public HotRestartBackupTransactionLogRecord(long backupSeq, Address initiator, Address target, UUID txnId, long leaseTime) {
        Preconditions.checkNotNull(initiator);
        Preconditions.checkNotNull(target);
        Preconditions.checkNotNull(txnId);
        Preconditions.checkPositive(leaseTime, "Lease time should be positive!");
        this.backupSeq = backupSeq;
        this.initiator = initiator;
        this.target = target;
        this.txnId = txnId;
        this.leaseTime = leaseTime;
    }

    @Override
    public Object getKey() {
        return null;
    }

    @Override
    public Operation newPrepareOperation() {
        return HotRestartBackupOperation.prepareOperation(this.initiator, this.txnId, this.leaseTime);
    }

    @Override
    public Operation newCommitOperation() {
        return HotRestartBackupOperation.commitOperation(this.backupSeq, this.initiator, this.txnId);
    }

    @Override
    public Operation newRollbackOperation() {
        return HotRestartBackupOperation.rollbackOperation(this.initiator, this.txnId);
    }

    @Override
    public Address getTarget() {
        return this.target;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.backupSeq);
        out.writeObject(this.initiator);
        out.writeObject(this.target);
        UUIDSerializationUtil.writeUUID(out, this.txnId);
        out.writeLong(this.leaseTime);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.backupSeq = in.readLong();
        this.initiator = (Address)in.readObject();
        this.target = (Address)in.readObject();
        this.txnId = UUIDSerializationUtil.readUUID(in);
        this.leaseTime = in.readLong();
    }

    @Override
    public int getFactoryId() {
        return HotRestartBackupSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 0;
    }
}

