/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hidensity.impl;

import com.hazelcast.internal.elastic.map.SampleableElasticHashMap;
import com.hazelcast.internal.hidensity.HiDensityRecord;
import com.hazelcast.internal.hidensity.HiDensityRecordMap;
import com.hazelcast.internal.hidensity.HiDensityRecordProcessor;
import com.hazelcast.internal.hidensity.HiDensityStorageInfo;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.memory.NativeOutOfMemoryError;

public class DefaultHiDensityRecordMap<R extends HiDensityRecord>
extends SampleableElasticHashMap<R>
implements HiDensityRecordMap<R> {
    protected final transient HiDensityRecordProcessor<R> recordProcessor;
    protected final transient HiDensityStorageInfo storageInfo;

    public DefaultHiDensityRecordMap(int initialCapacity, HiDensityRecordProcessor<R> recordProcessor, HiDensityStorageInfo storageInfo) {
        super(initialCapacity, recordProcessor);
        this.recordProcessor = recordProcessor;
        this.storageInfo = storageInfo;
    }

    protected void increaseEntryCount() {
        this.storageInfo.increaseEntryCount();
    }

    protected void decreaseEntryCount() {
        this.storageInfo.decreaseEntryCount();
    }

    protected void decreaseEntryCount(int entryCount) {
        this.storageInfo.removeEntryCount(entryCount);
    }

    @Override
    public boolean set(Data key, R value) {
        boolean added = super.set(key, value);
        if (added) {
            this.increaseEntryCount();
        }
        return added;
    }

    @Override
    public R put(Data key, R value) {
        HiDensityRecord record = (HiDensityRecord)super.put(key, value);
        if (record == null) {
            this.increaseEntryCount();
        }
        return (R)record;
    }

    @Override
    public R putIfAbsent(Data key, R value) {
        HiDensityRecord record = (HiDensityRecord)super.putIfAbsent(key, value);
        if (record == null) {
            this.increaseEntryCount();
        }
        return (R)record;
    }

    @Override
    public boolean delete(Data key) {
        boolean deleted = super.delete(key);
        if (deleted) {
            this.decreaseEntryCount();
        }
        return deleted;
    }

    @Override
    public R remove(Object k) {
        HiDensityRecord removedRecord = (HiDensityRecord)super.remove(k);
        if (removedRecord != null) {
            this.decreaseEntryCount();
        }
        return (R)removedRecord;
    }

    @Override
    public boolean remove(Object k, Object v) {
        boolean removed = super.remove(k, v);
        if (removed) {
            this.decreaseEntryCount();
        }
        return removed;
    }

    @Override
    public void clear() {
        int sizeBeforeClear = this.size();
        super.clear();
        this.decreaseEntryCount(sizeBeforeClear);
    }

    @Override
    protected NativeOutOfMemoryError onOome(NativeOutOfMemoryError e) {
        return new NativeOutOfMemoryError("Cannot expand internal cache map -> " + e.getMessage(), e);
    }
}

