/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.elastic.queue;

import com.hazelcast.internal.elastic.LongIterator;
import com.hazelcast.internal.elastic.queue.ElasticQueue;
import com.hazelcast.internal.elastic.queue.LongQueue;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.serialization.DataType;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import java.util.AbstractQueue;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;

abstract class AbstractElasticQueue<E>
extends AbstractQueue<E>
implements ElasticQueue<E> {
    private final LongQueue queue;
    private final EnterpriseSerializationService ss;
    private final Queue<NativeMemoryData> localBinaryQ = new ArrayDeque<NativeMemoryData>(1024);

    AbstractElasticQueue(EnterpriseSerializationService ss, int capacity, MemoryAllocator malloc) {
        this.ss = ss;
        this.queue = this.createQueue(malloc, capacity, 0L);
    }

    protected abstract LongQueue createQueue(MemoryAllocator var1, int var2, long var3);

    private void enqueueBinary(NativeMemoryData data) {
        if (data == null) {
            return;
        }
        data.reset(0L);
        this.localBinaryQ.offer(data);
    }

    private NativeMemoryData addressToBinary(long address) {
        if (address != 0L) {
            NativeMemoryData binary = this.localBinaryQ.poll();
            if (binary == null) {
                binary = new NativeMemoryData();
            }
            return binary.reset(address);
        }
        return null;
    }

    @Override
    public final boolean offer(E e) {
        NativeMemoryData binary = (NativeMemoryData)this.ss.toData(e, DataType.NATIVE);
        if (this.queue.offer(binary.address())) {
            this.enqueueBinary(binary);
            return true;
        }
        this.ss.disposeData(binary);
        this.enqueueBinary(binary);
        return false;
    }

    @Override
    public final E poll() {
        return this.first(true);
    }

    @Override
    public final E peek() {
        return this.first(false);
    }

    private E first(boolean remove) {
        long address = this.queue.poll();
        return this.toItem(address, remove);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private E toItem(long address, boolean dispose) {
        if (address != this.queue.nullItem()) {
            NativeMemoryData binary = this.addressToBinary(address);
            try {
                Object t = this.ss.toObject(binary);
                return (E)t;
            }
            finally {
                if (dispose) {
                    this.ss.disposeData(binary);
                }
                this.enqueueBinary(binary);
            }
        }
        return null;
    }

    @Override
    public final void clear() {
        this.queue.clear();
    }

    @Override
    public final int size() {
        return this.queue.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public final void destroy() {
        this.queue.dispose();
        this.localBinaryQ.clear();
    }

    @Override
    public final Iterator<E> iterator() {
        return new ItemIterator();
    }

    private class ItemIterator
    implements Iterator<E> {
        final LongIterator iter;

        private ItemIterator() {
            this.iter = AbstractElasticQueue.this.queue.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public E next() {
            long address = this.iter.next();
            return AbstractElasticQueue.this.toItem(address, false);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

