/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.elastic.map;

import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.memory.MemoryBlock;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.internal.util.HashUtil;

public class BehmSlotAccessor<V extends MemoryBlock> {
    static final long SLOT_LENGTH = 16L;
    static final int KEY_OFFSET = 0;
    static final int VALUE_OFFSET = 8;
    protected long baseAddr;
    protected long size;
    private final MemoryAllocator malloc;

    public BehmSlotAccessor(MemoryAllocator malloc, long baseAddr, long size) {
        this.malloc = malloc;
        this.baseAddr = baseAddr;
        this.size = size;
    }

    public BehmSlotAccessor(BehmSlotAccessor that) {
        this.malloc = that.malloc;
        this.baseAddr = that.baseAddr;
        this.size = that.size;
    }

    public static int rehash(Data o, int p) {
        return o == null ? 0 : HashUtil.MurmurHash3_fmix(o.hashCode() ^ p);
    }

    public static int rehash(int v, int p) {
        return HashUtil.MurmurHash3_fmix(v ^ p);
    }

    BehmSlotAccessor allocate(int slotCapacity) {
        this.size = (long)slotCapacity * 16L;
        this.baseAddr = this.malloc.allocate(this.size);
        return this;
    }

    void clear() {
        GlobalMemoryAccessorRegistry.AMEM.setMemory(this.baseAddr, this.size, (byte)0);
    }

    void delete() {
        this.malloc.free(this.baseAddr, this.size);
        this.baseAddr = 0L;
        this.size = 0L;
    }

    public boolean isAssigned(int slot) {
        return this.getKey(slot) != 0L;
    }

    public long getKey(int slot) {
        return GlobalMemoryAccessorRegistry.AMEM.getLong(this.slotBase(slot) + 0L);
    }

    public void setKey(int slot, long key) {
        GlobalMemoryAccessorRegistry.AMEM.putLong(this.slotBase(slot) + 0L, key);
    }

    public long getValue(int slot) {
        return GlobalMemoryAccessorRegistry.AMEM.getLong(this.slotBase(slot) + 8L);
    }

    public void setValue(int slot, long value) {
        GlobalMemoryAccessorRegistry.AMEM.putLong(this.slotBase(slot) + 8L, value);
    }

    public void setValue(int slot, V v) {
        long address = v == null ? 0L : ((MemoryBlock)v).address();
        GlobalMemoryAccessorRegistry.AMEM.putLong(this.slotBase(slot) + 8L, address);
    }

    public NativeMemoryData keyData(int slot) {
        long keyAddr = this.getKey(slot);
        if (keyAddr != 0L) {
            return new NativeMemoryData().reset(keyAddr);
        }
        return null;
    }

    private long slotBase(int slot) {
        return this.baseAddr + (long)slot * 16L;
    }

    public String toString() {
        return String.valueOf(this.baseAddr);
    }
}

