/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.dynamicconfig.rewrite;

import com.hazelcast.internal.dynamicconfig.rewrite.RewriteChunkXml;
import com.hazelcast.internal.dynamicconfig.rewrite.RewriteChunkYaml;
import com.hazelcast.internal.dynamicconfig.rewrite.RewritePath;
import java.util.regex.Pattern;

public abstract class RewriteChunk {
    static final int XML_INDENT = 4;
    static final int YAML_INDENT = 2;
    private static final String NEW_LINE_SEPARATOR_WIN = "\r\n";
    private static final String NEW_LINE_SEPARATOR_UNIX = "\n";
    private static final Pattern REGEX_WIN_NEW_LINE = Pattern.compile("\\r\\n");
    private static final Pattern REGEX_UNIX_NEW_LINE = Pattern.compile("(?<!\\r)\\n");
    String newLineSeparator;
    RewritePath path;
    String chunk;
    int timesExtended;
    boolean includesRootNode;
    private boolean formatted;

    RewriteChunk(RewritePath path, String chunk) {
        this.path = path;
        this.chunk = chunk;
    }

    static RewriteChunk newRewriteChunk(RewritePath path, String chunk, boolean configIsXml) {
        return configIsXml ? new RewriteChunkXml(path, chunk) : new RewriteChunkYaml(path, chunk);
    }

    void formatAndExtend(RewritePath differencePath, boolean shouldTrim, boolean unixSeparator) {
        if (this.formatted) {
            return;
        }
        if (unixSeparator) {
            this.toUnixLineSeparator();
            this.newLineSeparator = NEW_LINE_SEPARATOR_UNIX;
        } else {
            this.toWindowsLineSeparator();
            this.newLineSeparator = NEW_LINE_SEPARATOR_WIN;
        }
        this.moveNewLine();
        this.extend(differencePath);
        this.indent(this.getSpaceCount());
        if (shouldTrim) {
            this.chunk = this.chunk.trim();
        }
        if (this.includesRootNode) {
            this.chunk = this.chunk + this.newLineSeparator;
        }
        this.formatted = true;
    }

    abstract void indent(int var1);

    private void moveNewLine() {
        if (this.chunk.endsWith(this.newLineSeparator)) {
            this.chunk = this.chunk.substring(0, this.chunk.length() - 1);
        }
        if (!this.chunk.startsWith(this.newLineSeparator)) {
            this.chunk = this.newLineSeparator + this.chunk;
        }
    }

    abstract void extend(RewritePath var1);

    abstract int getSpaceCount();

    protected void toUnixLineSeparator() {
        this.chunk = REGEX_WIN_NEW_LINE.matcher(this.chunk).replaceAll(NEW_LINE_SEPARATOR_UNIX);
    }

    protected void toWindowsLineSeparator() {
        this.chunk = REGEX_UNIX_NEW_LINE.matcher(this.chunk).replaceAll(NEW_LINE_SEPARATOR_WIN);
    }
}

