/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.cluster.impl;

import com.hazelcast.instance.impl.OutOfMemoryErrorDispatcher;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.cluster.impl.ClusterVersionAutoUpgradeHelper;
import com.hazelcast.internal.cluster.impl.MemberMap;
import com.hazelcast.logging.ILogger;
import com.hazelcast.version.Version;
import java.util.Random;

class ClusterVersionAutoUpgradeTask
implements Runnable {
    private static final int MIN_BACKOFF_DELAY_SECONDS = 1;
    private static final int MAX_BACKOFF_ATTEMPT_NUMBER = 5;
    private final int attemptNumber;
    private final Random random = new Random();
    private final ILogger logger;
    private final ClusterServiceImpl clusterService;
    private final ClusterVersionAutoUpgradeHelper autoUpgradeHelper;

    ClusterVersionAutoUpgradeTask(ClusterServiceImpl clusterService, int attemptNumber, ClusterVersionAutoUpgradeHelper autoUpgradeHelper) {
        this.attemptNumber = attemptNumber;
        this.clusterService = clusterService;
        this.autoUpgradeHelper = autoUpgradeHelper;
        this.logger = clusterService.getNodeEngine().getLogger(ClusterVersionAutoUpgradeTask.class);
    }

    @Override
    public void run() {
        MemberMap memberMap = this.autoUpgradeHelper.getCheckedMemberMapOrNull(this.clusterService, this.logger);
        if (memberMap == null) {
            return;
        }
        try {
            this.tryUpgradeClusterVersion(memberMap);
        }
        catch (OutOfMemoryError e) {
            OutOfMemoryErrorDispatcher.onOutOfMemory(e);
        }
        catch (Throwable throwable) {
            this.logger.warning(String.format("Scheduling new task, caught %s: %s", throwable.getClass().getName(), throwable.getMessage()));
            this.rescheduleTaskWithBackoff();
        }
    }

    private void tryUpgradeClusterVersion(MemberMap memberMap) {
        Version nextClusterVersion = this.clusterService.getLocalMember().getVersion().asVersion();
        this.clusterService.changeClusterVersion(nextClusterVersion, memberMap);
        if (this.logger.isInfoEnabled()) {
            this.logger.info(String.format("Cluster version has been upgraded to %s", nextClusterVersion));
        }
    }

    private void rescheduleTaskWithBackoff() {
        int nextAttemptNumber = this.attemptNumber > 5 ? 5 : this.attemptNumber + 1;
        int nextDelaySeconds = Math.max(1, this.random.nextInt(1 << nextAttemptNumber));
        this.autoUpgradeHelper.scheduleNewAutoUpgradeTask(nextAttemptNumber, nextDelaySeconds, this.clusterService);
    }

    public String toString() {
        return "ClusterVersionAutoUpgradeTask{attemptNumber=" + this.attemptNumber + '}';
    }
}

