/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.bplustree;

import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.memory.MemoryAddressTranslator;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.tstore.Epoch;
import com.hazelcast.internal.tstore.compaction.IncrementalCompactor;
import com.hazelcast.internal.tstore.compaction.InterruptableCompactor;
import com.hazelcast.internal.tstore.device.Device;
import com.hazelcast.internal.tstore.hybridlog.HybridLogIteratorType;
import com.hazelcast.internal.tstore.hybridlog.InMemorySlotAccessor;
import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogImpl;
import com.hazelcast.internal.tstore.hybridlog.impl.LogBasedHybridLogIterator;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class TStoreBTreeCompactor
extends InterruptableCompactor<Void>
implements IncrementalCompactor {
    private static final int EPOCH_REFRESH_MASK_SHIFT = 4;
    private static final int EPOCH_REFRESH_MASK = 15;
    private static final ILogger LOGGER = Logger.getLogger(TStoreBTreeCompactor.class);
    protected final Dependencies dependencies;
    private final HybridLogImpl log;
    private final Device device;
    private final Epoch epoch;
    private final int segmentNo;
    private final SlotAccessor slotAccessor;
    private final LogBasedHybridLogIterator<AddressPair, AddressPair> logIterator;

    public TStoreBTreeCompactor(int nodeSize, HybridLogImpl log, Epoch epoch, Dependencies dependencies, int segmentNo) {
        super(log.getDevice());
        this.log = log;
        this.device = log.getDevice();
        this.epoch = epoch;
        this.dependencies = dependencies;
        this.segmentNo = segmentNo;
        long fromLogicalAddress = log.firstEntry(segmentNo);
        long toLogicalAddressInclusive = this.device.segmentLastLogicalAddress(segmentNo);
        this.slotAccessor = new SlotAccessor(nodeSize);
        this.logIterator = new LogBasedHybridLogIterator<AddressPair, AddressPair>(log, fromLogicalAddress, toLogicalAddressInclusive, this.slotAccessor, HybridLogIteratorType.BOUNDED);
    }

    @Override
    public void compact() {
        if (this.log.isInMemory(this.log.firstEntry(this.segmentNo))) {
            return;
        }
        this.onCompactionStart();
        int threadIndex = this.epoch.register();
        try {
            this.logIterator.init();
            int counter = 0;
            while (this.logIterator.hasNext()) {
                this.checkInterrupted();
                this.compact(this.logIterator.next());
                if ((++counter & 0xF) != 0) continue;
                this.refreshEpochAndState(threadIndex);
            }
            this.device.truncateAsync(this.segmentNo);
        }
        catch (Throwable ex) {
            this.onCompactionFinish(ex);
            throw ex;
        }
        finally {
            this.epoch.unregister(threadIndex);
            this.logIterator.close();
        }
        this.onCompactionFinish(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compact(AddressPair entry) {
        long lockAddress = this.dependencies.getLockAddress(entry.stable);
        this.dependencies.exclusiveLock(lockAddress);
        try {
            if (TStoreBTreeCompactor.read(entry.stable) == entry.logical) {
                this.log.readRecordForReadOnly(entry.logical, this.slotAccessor, (record, oldLogical, newLogical) -> {
                    TStoreBTreeCompactor.write(entry.stable, newLogical);
                    return newLogical;
                });
            }
        }
        finally {
            this.dependencies.releaseLock(lockAddress);
        }
    }

    private void refreshEpochAndState(int threadIndex) {
        this.epoch.refresh(threadIndex);
    }

    private void onCompactionStart() {
        if (LOGGER.isFineEnabled()) {
            LOGGER.fine("starting with compaction on b+tree HybridLog with id=" + this.log.getId() + ", segmentNo=" + this.segmentNo);
        }
    }

    private void onCompactionFinish(@Nullable Throwable ex) {
        this.deregister();
        if (ex != null) {
            LOGGER.warning(this.toReadableStr(ex));
        }
        if (LOGGER.isFineEnabled()) {
            LOGGER.fine("done with compaction on b+tree HybridLog with id=" + this.log.getId() + ", segmentNo=" + this.segmentNo);
        }
    }

    private String toReadableStr(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        String ln = System.lineSeparator();
        StringBuilder sb = new StringBuilder().append("Exception during compaction of b+tree HybridLog with id=").append(this.log.getId()).append(", segmentNo=").append(this.segmentNo).append(ln).append(throwable.getMessage()).append(ln);
        for (StackTraceElement e : throwable.getStackTrace()) {
            sb.append(e.toString()).append(ln);
        }
        return sb.toString();
    }

    private static long read(long address) {
        return GlobalMemoryAccessorRegistry.AMEM.getLongVolatile(address);
    }

    private static void write(long address, long value) {
        GlobalMemoryAccessorRegistry.AMEM.putLongVolatile(address, value);
    }

    private static final class SlotAccessor
    implements InMemorySlotAccessor<AddressPair, AddressPair> {
        final AddressPair entry = new AddressPair();
        final int nodeSize;

        SlotAccessor(int nodeSize) {
            this.nodeSize = nodeSize;
        }

        @Override
        public AddressPair prepare(long slotLogicalAddress, MemoryAddressTranslator translator) {
            this.entry.logical = slotLogicalAddress;
            this.entry.stable = TStoreBTreeCompactor.read(translator.asPhysicalAddress(slotLogicalAddress));
            return this.entry;
        }

        @Override
        public int size(AddressPair preparedSlot) {
            return this.nodeSize;
        }

        @Override
        public boolean isAlive(AddressPair preparedSlot) {
            return TStoreBTreeCompactor.read(preparedSlot.stable) <= preparedSlot.logical;
        }

        @Override
        public AddressPair asEntry(AddressPair preparedSlot) {
            return preparedSlot;
        }

        @Override
        public boolean lock(AddressPair preparedSlot) {
            return true;
        }

        @Override
        public void unlock(AddressPair preparedSlot) {
        }

        @Override
        public int headerSize() {
            return 0;
        }

        @Override
        public Data readValue(byte[] record) {
            return null;
        }

        @Override
        public int length(byte[] chunkPart) {
            return this.nodeSize;
        }
    }

    private static final class AddressPair {
        long logical;
        long stable;

        private AddressPair() {
        }
    }

    public static interface Dependencies {
        public long getLockAddress(long var1);

        public void exclusiveLock(long var1);

        public void releaseLock(long var1);
    }
}

