/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.bplustree;

import com.hazelcast.internal.bplustree.LockingContext;
import com.hazelcast.internal.bplustree.TStoreAllocator;
import com.hazelcast.internal.bplustree.TStoreBTreeCompactor;
import com.hazelcast.internal.bplustree.TStoreBTreeCompactorConstructorFn;
import com.hazelcast.internal.memory.AbstractPoolingMemoryManager;
import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.memory.IndexAllocator;
import com.hazelcast.internal.memory.MemoryAddressTranslator;
import com.hazelcast.internal.memory.PooledNativeMemoryStats;
import com.hazelcast.internal.memory.impl.LibMalloc;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.tstore.Epoch;
import com.hazelcast.internal.tstore.RecordPool;
import com.hazelcast.internal.tstore.State;
import com.hazelcast.internal.tstore.compaction.CompactionManager;
import com.hazelcast.internal.tstore.hybridlog.HybridLog;
import com.hazelcast.internal.tstore.hybridlog.InMemorySlotAccessor;
import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogImpl;
import com.hazelcast.internal.tstore.index.Index;
import com.hazelcast.internal.tstore.service.TStoreUserId;
import com.hazelcast.internal.util.collection.PartitionIdSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public final class TStoreBTreeAllocator
implements IndexAllocator,
TStoreAllocator {
    private static final long NULL = 0L;
    private final int nodeSize;
    private final Epoch epoch;
    private final HybridLog treeLog;
    private final Dependencies dependencies;
    private final AbstractPoolingMemoryManager.MetadataMemoryAllocator metadataAllocator;
    private final RecordPool nodes;
    private final SlotAccessor slotAccessor;
    private final AtomicBoolean disposed = new AtomicBoolean(false);

    public TStoreBTreeAllocator(LibMalloc malloc, PooledNativeMemoryStats memoryStats, int nodeSize, Epoch epoch, HybridLog treeLog, Dependencies dependencies) {
        this.nodeSize = nodeSize;
        this.epoch = epoch;
        this.treeLog = treeLog;
        this.dependencies = dependencies;
        this.metadataAllocator = new AbstractPoolingMemoryManager.MetadataMemoryAllocator(malloc, memoryStats);
        this.nodes = new RecordPool(this.metadataAllocator, 16);
        this.slotAccessor = new SlotAccessor(nodeSize);
    }

    @Override
    public int getNodeSize() {
        return this.nodeSize;
    }

    @Override
    public long allocate(long size) {
        assert (size == (long)this.nodeSize);
        long stableAddress = this.nodes.acquire();
        assert (stableAddress > 0L);
        return stableAddress;
    }

    @Override
    public void allocateLogical(long stableAddress) {
        long logicalAddress = this.treeLog.allocate(this.nodeSize);
        assert (logicalAddress > 0L);
        assert (this.treeLog.isMutable(logicalAddress));
        TStoreBTreeAllocator.write(stableAddress, logicalAddress);
        long physicalAddress = this.treeLog.asPhysicalAddress(logicalAddress);
        assert (physicalAddress > 0L);
        TStoreBTreeAllocator.write(physicalAddress, stableAddress);
    }

    @Override
    public long reallocate(long stableAddress, long currentSize, long newSize) {
        assert (stableAddress > 0L);
        assert (currentSize == (long)this.nodeSize);
        assert (currentSize == newSize);
        return stableAddress;
    }

    @Override
    public void free(long stableAddress, long size) {
        assert (stableAddress > 0L);
        assert (size == (long)this.nodeSize);
        this.nodes.release(stableAddress);
    }

    @Override
    public int getKeyPartition(Data key) {
        return this.dependencies.getPartition(key);
    }

    @Override
    public boolean isAllocated(long stableAddress) {
        return this.nodes.isAcquired(stableAddress);
    }

    @Override
    public long translateToLogical(long stableAddress) {
        assert (stableAddress > 0L) : stableAddress;
        long logicalAddress = TStoreBTreeAllocator.read(stableAddress);
        assert (logicalAddress > 0L) : stableAddress + " " + logicalAddress;
        return logicalAddress;
    }

    @Override
    public long translateToPhysical(long stableAddress) {
        long logicalAddress = this.translateToLogical(stableAddress);
        long physicalAddress = this.treeLog.asPhysicalAddress(logicalAddress);
        assert (physicalAddress > 0L) : physicalAddress;
        return physicalAddress;
    }

    @Override
    public long getLockAddress(long stableAddress) {
        assert (stableAddress > 0L);
        return stableAddress + 8L;
    }

    @Override
    public long tryLockRecord(int partition, long keyHash) {
        int threadIndex = this.epoch.getCurrentThreadIndex();
        State state = this.dependencies.getState(partition);
        state.refresh(threadIndex);
        Index index = this.dependencies.getIndex(partition);
        return index.tryLock(threadIndex, keyHash);
    }

    @Override
    public void waitUntilRecordUnlocked(int partition, long keyHash, long cookie) {
        Index index = this.dependencies.getIndex(partition);
        index.waitUntilUnlocked(this.epoch.getCurrentThreadIndex(), keyHash, cookie);
    }

    @Override
    public void unlockRecord(int partition, long keyHash, long cookie) {
        Index index = this.dependencies.getIndex(partition);
        index.unlock(keyHash, cookie);
    }

    @Override
    public Data getRecordValue(int partition, Data key) {
        int threadIndex = this.epoch.getCurrentThreadIndex();
        Index index = this.dependencies.getIndex(partition);
        long record = index.getRaw(threadIndex, key, -1L, false);
        if (record == -1L) {
            return TStoreAllocator.RETRY;
        }
        if (record == 0L) {
            return null;
        }
        return this.dependencies.getRecordValue(partition, key, record);
    }

    @Override
    public void yield(int partition) {
        int threadPhase;
        int threadIndex = this.epoch.getCurrentThreadIndex();
        State state = this.dependencies.getState(partition);
        do {
            Thread.yield();
            this.epoch.refresh(threadIndex);
        } while ((threadPhase = State.phase(state.refresh(threadIndex))) != 0);
    }

    @Override
    public void pinAndReplaceLastUnpinned(long stableAddress, LockingContext lockingContext) {
        long replaced = lockingContext.replaceAddressToPin(stableAddress);
        if (replaced == -1L) {
            return;
        }
        boolean mutable = replaced < 0L;
        long stablePinAddress = Math.abs(replaced);
        long logicalAddress = this.translateToLogical(stablePinAddress);
        if (mutable) {
            while (!this.treeLog.pinAddressForUpdate(logicalAddress)) {
                this.epoch.refresh(this.epoch.getCurrentThreadIndex());
                this.treeLog.readRecordForUpdate(logicalAddress, this.slotAccessor, (record, oldLogicalAddress, newLogicalAddress) -> {
                    TStoreBTreeAllocator.cas(stablePinAddress, oldLogicalAddress, newLogicalAddress);
                    return newLogicalAddress;
                });
                logicalAddress = this.translateToLogical(stablePinAddress);
            }
            assert (this.treeLog.isInMemory(logicalAddress));
        } else {
            while (!this.treeLog.pinAddress(logicalAddress)) {
                this.epoch.refresh(this.epoch.getCurrentThreadIndex());
                this.treeLog.readRecordForReadOnly(logicalAddress, this.slotAccessor, (record, oldLogicalAddress, newLogicalAddress) -> {
                    TStoreBTreeAllocator.cas(stablePinAddress, oldLogicalAddress, newLogicalAddress);
                    return newLogicalAddress;
                });
                logicalAddress = this.translateToLogical(stablePinAddress);
            }
            assert (this.treeLog.isInMemory(logicalAddress));
        }
        lockingContext.addPin(stablePinAddress);
    }

    @Override
    public void unpinIfNotLastUnpinned(long stableAddress, LockingContext lockingContext) {
        long consumed = lockingContext.consumeAddressToUnpin(stableAddress);
        if (consumed == -1L) {
            return;
        }
        long logicalAddress = this.translateToLogical(consumed);
        this.treeLog.unpinAddress(logicalAddress);
        lockingContext.removePin(consumed);
    }

    @Override
    public void unpin(long stableAddress) {
        long logicalAddress = this.translateToLogical(stableAddress);
        this.treeLog.unpinAddress(logicalAddress);
    }

    @Override
    public void ensureReadable(long stableAddress) {
        long logicalAddress;
        while (!this.treeLog.isInMemory(logicalAddress = this.translateToLogical(stableAddress))) {
            this.epoch.refresh(this.epoch.getCurrentThreadIndex());
            this.treeLog.readRecordForReadOnly(logicalAddress, this.slotAccessor, (record, oldLogicalAddress, newLogicalAddress) -> {
                TStoreBTreeAllocator.cas(stableAddress, oldLogicalAddress, newLogicalAddress);
                return newLogicalAddress;
            });
        }
        return;
    }

    @Override
    public void ensureWritable(long stableAddress) {
        long logicalAddress;
        while (!this.treeLog.isMutable(logicalAddress = this.translateToLogical(stableAddress))) {
            this.epoch.refresh(this.epoch.getCurrentThreadIndex());
            this.treeLog.readRecordForUpdate(logicalAddress, this.slotAccessor, (record, oldLogicalAddress, newLogicalAddress) -> {
                TStoreBTreeAllocator.cas(stableAddress, oldLogicalAddress, newLogicalAddress);
                return newLogicalAddress;
            });
        }
        return;
    }

    @Override
    public void upgradeToWritable(long stableAddress, LockingContext lockingContext) {
        if (lockingContext.isPinned(stableAddress)) {
            this.treeLog.unpinAddress(this.translateToLogical(stableAddress));
            lockingContext.removePin(stableAddress);
            this.pinAndReplaceLastUnpinned(-stableAddress, lockingContext);
        } else {
            long replaced = lockingContext.replaceAddressToPin(-stableAddress);
            assert (stableAddress == Math.abs(replaced));
        }
        this.ensureWritable(stableAddress);
    }

    @Override
    public void dispose() {
        if (!this.disposed.compareAndSet(false, true)) {
            return;
        }
        this.nodes.close();
        this.metadataAllocator.dispose();
    }

    @Override
    public List<Long> getNodeAddressesFromFreeQueue() {
        throw new UnsupportedOperationException();
    }

    private static long read(long address) {
        return GlobalMemoryAccessorRegistry.AMEM.getLongVolatile(address);
    }

    private static void write(long address, long value) {
        GlobalMemoryAccessorRegistry.AMEM.putLongVolatile(address, value);
    }

    private static boolean cas(long address, long expected, long value) {
        return GlobalMemoryAccessorRegistry.AMEM.compareAndSwapLong(address, expected, value);
    }

    @Override
    public void registerEpoch() {
        this.epoch.register();
    }

    @Override
    public void unregisterEpoch() {
        int threadIndex = this.epoch.getCurrentThreadIndex();
        this.epoch.unregister(threadIndex);
    }

    @Override
    public void pauseEpoch() {
        this.epoch.pause(this.epoch.getCurrentThreadIndex());
    }

    @Override
    public void resumeEpoch() {
        this.epoch.resume(this.epoch.getCurrentThreadIndex());
    }

    @Override
    public void registerState(int partitionId) {
        int threadIndex = this.epoch.getCurrentThreadIndex();
        this.dependencies.getState(partitionId).register(threadIndex);
    }

    @Override
    public void unregisterState(int partitionId) {
        int threadIndex = this.epoch.getCurrentThreadIndex();
        this.dependencies.getState(partitionId).unregister(threadIndex);
    }

    @Override
    public PartitionIdSet newPartitionIdSet() {
        return this.dependencies.newPartitionIdSet();
    }

    @Override
    public void registerCompactor(TStoreBTreeCompactor.Dependencies compactorDeps) {
        TStoreUserId userId = ((HybridLogImpl)this.treeLog).getDevice().userId();
        TStoreBTreeCompactorConstructorFn constructorFn = new TStoreBTreeCompactorConstructorFn(this.getNodeSize(), (HybridLogImpl)this.treeLog, this.epoch, compactorDeps);
        this.dependencies.getCompactionManager().addCompactorConstructorFn(userId, 0, constructorFn);
    }

    private static final class SlotAccessor
    implements InMemorySlotAccessor<Void, Void> {
        private final int nodeSize;

        SlotAccessor(int nodeSize) {
            this.nodeSize = nodeSize;
        }

        @Override
        public Void prepare(long slotLogicalAddress, MemoryAddressTranslator translator) {
            return null;
        }

        @Override
        public int size(Void preparedSlot) {
            return this.nodeSize;
        }

        @Override
        public boolean isAlive(Void preparedSlot) {
            return true;
        }

        @Override
        public Void asEntry(Void preparedSlot) {
            return null;
        }

        @Override
        public boolean lock(Void preparedSlot) {
            return true;
        }

        @Override
        public void unlock(Void preparedSlot) {
        }

        @Override
        public int headerSize() {
            return 0;
        }

        @Override
        public Data readValue(byte[] record) {
            return null;
        }

        @Override
        public int length(byte[] chunkPart) {
            return this.nodeSize;
        }
    }

    public static interface Dependencies {
        public int getPartition(Data var1);

        public State getState(int var1);

        public Index getIndex(int var1);

        public Data getRecordValue(int var1, Data var2, long var3);

        public PartitionIdSet newPartitionIdSet();

        public CompactionManager getCompactionManager();
    }
}

