/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.bplustree;

import com.hazelcast.internal.bplustree.BPlusTreeKeyAccessor;
import com.hazelcast.internal.bplustree.BPlusTreeKeyComparator;
import com.hazelcast.internal.bplustree.CompositeKeyComparison;
import com.hazelcast.internal.bplustree.EntrySlotPayload;
import com.hazelcast.internal.bplustree.HDBTreeNodeBaseAccessor;
import com.hazelcast.internal.bplustree.LockManager;
import com.hazelcast.internal.bplustree.LockingContext;
import com.hazelcast.internal.bplustree.NodeSplitStrategy;
import com.hazelcast.internal.bplustree.TStoreAllocator;
import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;

class HDBTreeLeafNodeAccessor
extends HDBTreeNodeBaseAccessor {
    private static final int OFFSET_ADDR_BACK = 20;
    private static final int OFFSET_ADDR_FORW = 28;
    private static final int OFFSET_LEAF_ENTRIES = 36;
    static final int HEADER_SIZE = 36;

    HDBTreeLeafNodeAccessor(LockManager lockManager, EnterpriseSerializationService ess, BPlusTreeKeyComparator keyComparator, BPlusTreeKeyAccessor keyAccessor, MemoryAllocator keyAllocator, MemoryAllocator btreeAllocator, int nodeSize, NodeSplitStrategy nodeSplitStrategy, EntrySlotPayload entrySlotPayload) {
        super(lockManager, ess, keyComparator, keyAccessor, keyAllocator, btreeAllocator, nodeSize, nodeSplitStrategy, entrySlotPayload);
    }

    @Override
    long newNodeLocked(LockingContext lockingContext) {
        long address = super.newNodeLocked(lockingContext);
        this.setBackNode(address, 0L);
        this.setForwNode(address, 0L);
        return address;
    }

    @Override
    int getOffsetEntries() {
        return 36;
    }

    long getBackNode(long nodeAddr) {
        return GlobalMemoryAccessorRegistry.AMEM.getLong(this.translateToPhysical(nodeAddr) + 20L);
    }

    void setBackNode(long nodeAddr, long backAddr) {
        long p = this.translateToPhysical(nodeAddr);
        GlobalMemoryAccessorRegistry.AMEM.putLong(p + 20L, backAddr);
    }

    long getForwNode(long nodeAddr) {
        return GlobalMemoryAccessorRegistry.AMEM.getLong(this.translateToPhysical(nodeAddr) + 28L);
    }

    void setForwNode(long nodeAddr, long forwAddr) {
        long p = this.translateToPhysical(nodeAddr);
        GlobalMemoryAccessorRegistry.AMEM.putLong(p + 28L, forwAddr);
    }

    NativeMemoryData insert(long nodeAddr, Comparable indexKeyComparable, NativeMemoryData indexKey, NativeMemoryData entryKey, long valueAddress) {
        boolean found;
        int slot;
        int keysCount;
        block6: {
            keysCount = this.getKeysCount(nodeAddr);
            assert (!this.isNodeFull(nodeAddr, indexKey, entryKey) && keysCount >= 0);
            int lower = 0;
            int upper = keysCount - 1;
            int mid = 0;
            slot = 0;
            found = false;
            while (true) {
                if (upper < lower) {
                    slot = lower;
                    break block6;
                }
                mid = (upper + lower) / 2;
                CompositeKeyComparison cmp = this.compareKeys(indexKeyComparable, entryKey, nodeAddr, mid);
                if (CompositeKeyComparison.less(cmp)) {
                    upper = mid - 1;
                    continue;
                }
                if (!CompositeKeyComparison.greater(cmp)) break;
                lower = mid + 1;
            }
            slot = mid;
            found = true;
        }
        if (slot < keysCount && found) {
            int partition = this.getKeyPartition(entryKey);
            NativeMemoryData oldValue = (NativeMemoryData)this.getValue(nodeAddr, slot, partition, entryKey);
            if (oldValue == TStoreAllocator.RETRY) {
                return TStoreAllocator.RETRY;
            }
            this.setValueAddr(nodeAddr, slot, valueAddress);
            this.incSequenceCounter(nodeAddr);
            return oldValue;
        }
        this.insertSlot(nodeAddr, slot, indexKey, entryKey, valueAddress);
        this.incSequenceCounter(nodeAddr);
        return null;
    }

    Data remove(long nodeAddr, Comparable indexKey, NativeMemoryData entryKey) {
        Data oldValue = null;
        int keysCount = this.getKeysCount(nodeAddr);
        if (keysCount > 0) {
            int mid;
            int lower = 0;
            int upper = keysCount - 1;
            while (true) {
                if (upper < lower) {
                    return null;
                }
                mid = (upper + lower) / 2;
                CompositeKeyComparison cmp = this.compareKeys(indexKey, entryKey, nodeAddr, mid);
                if (CompositeKeyComparison.less(cmp)) {
                    upper = mid - 1;
                    continue;
                }
                if (!CompositeKeyComparison.greater(cmp)) break;
                lower = mid + 1;
            }
            assert (mid <= keysCount);
            int partition = this.getKeyPartition(entryKey);
            oldValue = this.getValue(nodeAddr, mid, partition, entryKey);
            if (oldValue == TStoreAllocator.RETRY) {
                return TStoreAllocator.RETRY;
            }
            this.removeSlot(nodeAddr, mid);
            this.incSequenceCounter(nodeAddr);
        }
        return oldValue;
    }

    @Override
    long split(long nodeAddr, LockingContext lockingContext) {
        assert (this.getNodeLevel(nodeAddr) == 0);
        long newLeaf = this.newNodeLocked(lockingContext);
        int keysCount = this.getKeysCount(nodeAddr);
        int newLeafKeysCount = this.nodeSplitStrategy.getNewNodeKeysCount(keysCount);
        if (newLeafKeysCount > 0) {
            int startSlot = keysCount - newLeafKeysCount;
            int endSlotInclusive = keysCount - 1;
            long memCpyStartAddr = this.getSlotAddr(nodeAddr, startSlot);
            long memCpyEndAddr = this.freeSpaceBeginAddr(nodeAddr);
            GlobalMemoryAccessorRegistry.AMEM.copyMemory(memCpyStartAddr, this.translateToPhysical(newLeaf) + (long)this.getOffsetEntries(), memCpyEndAddr - memCpyStartAddr);
            this.setKeysCount(newLeaf, newLeafKeysCount);
            long startSlotEntryOffset = this.getSlotEntryOffset(nodeAddr, startSlot);
            for (int slot = 0; slot <= endSlotInclusive - startSlot; ++slot) {
                this.setSlotEntryOffset(newLeaf, slot, (short)((long)this.getSlotEntryOffset(nodeAddr, startSlot + slot) - startSlotEntryOffset));
            }
            this.removeLastKSlotEntries(nodeAddr, newLeafKeysCount);
        }
        this.incSequenceCounter(nodeAddr);
        this.incSequenceCounter(newLeaf);
        return newLeaf;
    }

    @Override
    int getSeparationSlot(long nodeAddr) {
        assert (this.getNodeLevel(nodeAddr) == 0);
        int keysCount = this.getKeysCount(nodeAddr);
        return keysCount - this.nodeSplitStrategy.getNewNodeKeysCount(keysCount) - 1;
    }

    @Override
    void removeLastKSlotEntries(long nodeAddr, int k) {
        int keysCount = this.getKeysCount(nodeAddr);
        assert (k <= keysCount);
        if (k < keysCount) {
            long zerosSlotEntryOffsetAddr = this.getSlotEntryOffsetAddr(nodeAddr, 0);
            int shift = k * 2;
            GlobalMemoryAccessorRegistry.AMEM.copyMemory(zerosSlotEntryOffsetAddr, zerosSlotEntryOffsetAddr + (long)shift, (long)(keysCount - k) * 2L);
        }
        this.setKeysCount(nodeAddr, keysCount - k);
    }

    @Override
    long freeSpaceBeginAddr(long nodeAddr) {
        assert (this.getNodeLevel(nodeAddr) == 0);
        int lastSlot = this.getLastSlot(nodeAddr);
        if (lastSlot == -1) {
            return this.translateToPhysical(nodeAddr) + (long)this.getOffsetEntries();
        }
        long lastEntryKeyAddr = this.getEntryKeyAddr(nodeAddr, lastSlot);
        return lastEntryKeyAddr + (long)this.readSize(lastEntryKeyAddr);
    }

    @Override
    int getLastSlot(long nodeAddr) {
        assert (this.getNodeLevel(nodeAddr) == 0);
        return this.getKeysCount(nodeAddr) - 1;
    }

    NativeMemoryData toNativeData(Comparable indexKey) {
        return (NativeMemoryData)this.ess.toNativeData(indexKey, this.getKeyAllocator());
    }

    void disposeIndexKeyNative(NativeMemoryData indexKeyNative) {
        this.ess.disposeData(indexKeyNative, this.getKeyAllocator());
    }
}

