/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.bplustree;

import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.internal.serialization.impl.NativeMemoryDataUtil;

public interface BPlusTreeKeyComparator {
    public int compare(Comparable var1, long var2, long var4);

    default public int compareSerializedKeys(Data left, NativeMemoryData rightData) {
        int rightDataSize;
        if (left instanceof NativeMemoryData) {
            int rightDataSize2;
            NativeMemoryData leftData = (NativeMemoryData)left;
            long leftDataAddress = leftData.address();
            long rightDataAddress = rightData.address();
            int leftDataSize = NativeMemoryDataUtil.readDataSize(leftDataAddress);
            if (leftDataSize != (rightDataSize2 = NativeMemoryDataUtil.readDataSize(rightDataAddress))) {
                return leftDataSize < rightDataSize2 ? -1 : 1;
            }
            for (int i = 0; i < leftDataSize; ++i) {
                byte k2;
                byte k1 = GlobalMemoryAccessorRegistry.MEM.getByte(leftDataAddress + 12L + (long)i);
                if (k1 == (k2 = GlobalMemoryAccessorRegistry.MEM.getByte(rightDataAddress + 12L + (long)i))) continue;
                return k1 < k2 ? -1 : 1;
            }
            return 0;
        }
        byte[] leftArray = left.toByteArray();
        long rightDataAddress = rightData.address();
        int leftDataSize = left.dataSize();
        if (leftDataSize != (rightDataSize = NativeMemoryDataUtil.readDataSize(rightData.address()))) {
            return leftDataSize < rightDataSize ? -1 : 1;
        }
        int leftDataOffset = left.totalSize() - left.dataSize();
        for (int i = 0; i < leftDataSize; ++i) {
            byte k1 = leftArray[leftDataOffset + i];
            byte k2 = GlobalMemoryAccessorRegistry.MEM.getByte(rightDataAddress + 12L + (long)i);
            if (k1 == k2) continue;
            return k1 < k2 ? -1 : 1;
        }
        return 0;
    }

    default public Comparable wrapIndexKey(Comparable indexKey) {
        return indexKey;
    }

    default public Comparable unwrapIndexKey(Comparable indexKey) {
        return indexKey;
    }
}

