/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl.sync;

import com.hazelcast.enterprise.wan.impl.operation.WanDataSerializerHook;
import com.hazelcast.internal.util.SetUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class WanAntiEntropyEventResult
implements IdentifiedDataSerializable {
    private Set<Integer> processedPartitions = new HashSet<Integer>();

    public Set<Integer> getProcessedPartitions() {
        return this.processedPartitions;
    }

    public void addProcessedPartitions(Collection<Integer> processedPartitions) {
        this.processedPartitions.addAll(processedPartitions);
    }

    @Override
    public int getFactoryId() {
        return WanDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 14;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.processedPartitions.size());
        for (Integer processedPartition : this.processedPartitions) {
            out.writeInt(processedPartition);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int size = in.readInt();
        this.processedPartitions = SetUtil.createHashSet(size);
        for (int i = 0; i < size; ++i) {
            this.processedPartitions.add(in.readInt());
        }
    }
}

