/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl.replication;

import com.hazelcast.enterprise.wan.impl.WanEventQueue;
import com.hazelcast.enterprise.wan.impl.replication.PollSynchronizerPublisherQueueContainer;
import com.hazelcast.enterprise.wan.impl.replication.WanElementCounter;
import com.hazelcast.internal.partition.MigrationEndpoint;
import com.hazelcast.internal.partition.PartitionMigrationEvent;
import com.hazelcast.wan.WanMigrationAwarePublisher;
import java.util.function.Predicate;

class WanQueueMigrationSupport
implements WanMigrationAwarePublisher {
    private final PollSynchronizerPublisherQueueContainer eventQueueContainer;
    private final WanElementCounter wanCounter;

    WanQueueMigrationSupport(PollSynchronizerPublisherQueueContainer eventQueueContainer, WanElementCounter wanCounter) {
        this.eventQueueContainer = eventQueueContainer;
        this.wanCounter = wanCounter;
    }

    @Override
    public void onMigrationStart(PartitionMigrationEvent event) {
        this.eventQueueContainer.blockPollingPartition(event.getPartitionId());
    }

    @Override
    public void onMigrationCommit(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE) {
            this.removeWanQueues(event.getPartitionId(), event.getCurrentReplicaIndex(), event.getNewReplicaIndex());
        }
        int partitionId = event.getPartitionId();
        int newReplicaIndex = event.getNewReplicaIndex();
        int currentReplicaIndex = event.getCurrentReplicaIndex();
        if (newReplicaIndex == 0) {
            int qSize = this.eventQueueContainer.getEventQueue(partitionId).size();
            this.wanCounter.moveFromBackupToPrimaryCounter(qSize);
        } else if (currentReplicaIndex == 0 && newReplicaIndex > 0) {
            int qSize = this.eventQueueContainer.getEventQueue(partitionId).size();
            this.wanCounter.moveFromPrimaryToBackupCounter(qSize);
        }
        this.eventQueueContainer.unblockPollingPartition(partitionId);
    }

    @Override
    public void onMigrationRollback(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.DESTINATION) {
            this.removeWanQueues(event.getPartitionId(), event.getCurrentReplicaIndex(), event.getCurrentReplicaIndex());
        }
        this.eventQueueContainer.unblockPollingPartition(event.getPartitionId());
    }

    private void removeWanQueues(int partitionId, int currentReplicaIndex, int thresholdReplicaIndex) {
        int sizeBeforeClear = 0;
        Predicate<WanEventQueue> predicate = q -> thresholdReplicaIndex < 0 || q.getBackupCount() < thresholdReplicaIndex;
        sizeBeforeClear += this.eventQueueContainer.drainMapQueuesMatchingPredicate(partitionId, predicate);
        this.onWanQueueClearedDuringMigration(currentReplicaIndex, sizeBeforeClear += this.eventQueueContainer.drainCacheQueuesMatchingPredicate(partitionId, predicate));
    }

    private void onWanQueueClearedDuringMigration(int currentReplicaIndex, int clearedQueueDepth) {
        if (currentReplicaIndex == 0) {
            this.wanCounter.decrementPrimaryElementCounter(clearedQueueDepth);
        } else {
            this.wanCounter.decrementBackupElementCounter(clearedQueueDepth);
        }
    }
}

