/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl.replication;

import com.hazelcast.cluster.Address;
import com.hazelcast.enterprise.wan.impl.replication.BatchReplicationStrategy;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SerialBatchReplicationStrategy
implements BatchReplicationStrategy {
    private final Set<Address> currentEndpointInvocations = Collections.newSetFromMap(new ConcurrentHashMap());
    private int endpointIndexOffset;

    @Override
    public Address getNextEventBatchEndpoint(List<Address> endpoints) {
        if (endpoints.isEmpty()) {
            return null;
        }
        int endpointCount = endpoints.size();
        this.endpointIndexOffset = (this.endpointIndexOffset + 1) % endpointCount;
        for (int i = 0; i < endpointCount; ++i) {
            Address endpoint = endpoints.get((i + this.endpointIndexOffset) % endpointCount);
            if (!this.currentEndpointInvocations.add(endpoint)) continue;
            return endpoint;
        }
        return null;
    }

    @Override
    public void complete(Address endpoint) {
        this.currentEndpointInvocations.remove(endpoint);
    }

    @Override
    public int getFirstPartitionId(Address endpoint, List<Address> endpoints) {
        return endpoints.indexOf(endpoint);
    }

    @Override
    public int getPartitionIdStep(Address endpoint, List<Address> endpoints) {
        return endpoints.size();
    }

    @Override
    public boolean hasOngoingReplication() {
        return !this.currentEndpointInvocations.isEmpty();
    }

    public String toString() {
        return "SerialBatchReplicationStrategy{currentEndpointInvocations=" + this.currentEndpointInvocations + '}';
    }
}

