/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl.operation;

import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.cache.impl.wan.WanEnterpriseCacheEvent;
import com.hazelcast.enterprise.wan.impl.EnterpriseWanReplicationService;
import com.hazelcast.enterprise.wan.impl.operation.WanBackupAwareOperation;
import com.hazelcast.enterprise.wan.impl.operation.WanPutBackupOperation;
import com.hazelcast.internal.services.ServiceNamespace;
import com.hazelcast.internal.services.ServiceNamespaceAware;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.wan.WanEnterpriseMapEvent;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.wan.impl.InternalWanEvent;
import java.io.IOException;

public class WanPutOperation
extends WanBackupAwareOperation
implements IdentifiedDataSerializable,
ServiceNamespaceAware {
    private ServiceNamespace objectNamespace;
    private InternalWanEvent event;

    public WanPutOperation() {
    }

    public WanPutOperation(String wanReplicationName, String targetName, InternalWanEvent event, int backupCount) {
        super(wanReplicationName, targetName, backupCount);
        this.event = event;
    }

    @Override
    public void run() throws Exception {
        EnterpriseWanReplicationService wanReplicationService = this.getEWRService();
        wanReplicationService.getPublisherOrFail(this.wanReplicationName, this.wanPublisherId).publishReplicationEvent(this.event);
        this.response = true;
    }

    @Override
    public boolean shouldBackup() {
        return Boolean.TRUE.equals(this.response);
    }

    @Override
    public Operation getBackupOperation() {
        return new WanPutBackupOperation(this.wanReplicationName, this.wanPublisherId, this.event, this.getServiceNamespace());
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.event);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.event = (InternalWanEvent)in.readObject();
    }

    @Override
    public int getClassId() {
        return 1;
    }

    @Override
    public ServiceNamespace getServiceNamespace() {
        if (this.objectNamespace != null) {
            return this.objectNamespace;
        }
        switch (this.event.getServiceName()) {
            case "hz:impl:mapService": {
                WanEnterpriseMapEvent mapEvent = (WanEnterpriseMapEvent)this.event;
                this.objectNamespace = MapService.getObjectNamespace(mapEvent.getMapName());
                break;
            }
            case "hz:impl:cacheService": {
                WanEnterpriseCacheEvent cacheEvent = (WanEnterpriseCacheEvent)this.event;
                this.objectNamespace = CacheService.getObjectNamespace(cacheEvent.getCacheName());
                break;
            }
            default: {
                throw new IllegalStateException("Forwarding WAN event for unknown service: " + this.event.getServiceName());
            }
        }
        return this.objectNamespace;
    }
}

