/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl.operation;

import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.enterprise.wan.impl.operation.AddWanConfigBackupOperation;
import com.hazelcast.enterprise.wan.impl.operation.WanDataSerializerHook;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.nio.serialization.impl.Versioned;
import com.hazelcast.spi.impl.operationservice.BackupAwareOperation;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;

public class AddWanConfigOperation
extends Operation
implements IdentifiedDataSerializable,
BackupAwareOperation,
Versioned {
    private WanReplicationConfig wanReplicationConfig;
    private boolean shouldBackup = true;

    public AddWanConfigOperation() {
    }

    public AddWanConfigOperation(WanReplicationConfig wanReplicationConfig, boolean shouldBackup) {
        this.wanReplicationConfig = wanReplicationConfig;
        this.shouldBackup = shouldBackup;
    }

    @Override
    public void run() throws Exception {
        this.getNodeEngine().getWanReplicationService().addWanReplicationConfigLocally(this.wanReplicationConfig);
    }

    @Override
    public boolean shouldBackup() {
        return this.shouldBackup;
    }

    @Override
    public int getSyncBackupCount() {
        return 6;
    }

    @Override
    public int getAsyncBackupCount() {
        return 0;
    }

    @Override
    public Operation getBackupOperation() {
        return new AddWanConfigBackupOperation(this.wanReplicationConfig);
    }

    @Override
    public String getServiceName() {
        return null;
    }

    @Override
    public int getFactoryId() {
        return WanDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 21;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeObject(this.wanReplicationConfig);
        if (out.getVersion().isGreaterOrEqual(Versions.V4_1)) {
            out.writeBoolean(this.shouldBackup);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.wanReplicationConfig = (WanReplicationConfig)in.readObject();
        if (in.getVersion().isGreaterOrEqual(Versions.V4_1)) {
            this.shouldBackup = in.readBoolean();
        }
    }
}

