/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl;

import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.enterprise.wan.impl.EnterpriseWanReplicationService;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.partition.ChunkedMigrationAwareService;
import com.hazelcast.internal.partition.PartitionMigrationEvent;
import com.hazelcast.internal.partition.PartitionReplicationEvent;
import com.hazelcast.internal.services.ObjectNamespace;
import com.hazelcast.internal.services.ServiceNamespace;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.wan.WanMigrationAwarePublisher;
import com.hazelcast.wan.WanPublisher;
import com.hazelcast.wan.impl.DelegatingWanScheme;
import com.hazelcast.wan.impl.WanEventContainerReplicationOperation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

class WanMigrationAwareService
implements ChunkedMigrationAwareService {
    private final EnterpriseWanReplicationService wanReplicationService;
    private final Node node;

    WanMigrationAwareService(EnterpriseWanReplicationService wanReplicationService, Node node) {
        this.wanReplicationService = wanReplicationService;
        this.node = node;
    }

    @Override
    public Collection<ServiceNamespace> getAllServiceNamespaces(PartitionReplicationEvent event) {
        ConcurrentHashMap<String, DelegatingWanScheme> wanReplications = this.getWanReplications();
        if (wanReplications.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<ServiceNamespace> namespaces = new HashSet<ServiceNamespace>();
        for (DelegatingWanScheme publisher : wanReplications.values()) {
            publisher.collectAllServiceNamespaces(event, namespaces);
        }
        return namespaces;
    }

    @Override
    public boolean isKnownServiceNamespace(ServiceNamespace namespace) {
        String serviceName = namespace.getServiceName();
        return namespace instanceof ObjectNamespace && ("hz:impl:mapService".equals(serviceName) || "hz:impl:cacheService".equals(serviceName));
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event, Collection<ServiceNamespace> namespaces) {
        ConcurrentHashMap<String, DelegatingWanScheme> wanReplications = this.getWanReplications();
        if (wanReplications.isEmpty() || namespaces.isEmpty()) {
            return null;
        }
        Map<String, Map<String, Object>> eventContainers = MapUtil.createHashMap(wanReplications.size());
        for (Map.Entry<String, DelegatingWanScheme> wanReplicationEntry : wanReplications.entrySet()) {
            String replicationScheme = wanReplicationEntry.getKey();
            DelegatingWanScheme delegate = wanReplicationEntry.getValue();
            Map<String, Object> publisherEventContainers = delegate.prepareEventContainerReplicationData(event, namespaces);
            if (publisherEventContainers.isEmpty()) continue;
            eventContainers.put(replicationScheme, publisherEventContainers);
        }
        Collection<WanReplicationConfig> wanReplicationConfigs = this.node.getConfig().getWanReplicationConfigs().values();
        if (eventContainers.isEmpty() && wanReplicationConfigs.isEmpty()) {
            return null;
        }
        return new WanEventContainerReplicationOperation(wanReplicationConfigs, eventContainers, event.getPartitionId(), event.getReplicaIndex());
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        return this.prepareReplicationOperation(event, this.getAllServiceNamespaces(event));
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent event) {
        this.notifyMigrationAwarePublishers(p -> p.onMigrationStart(event));
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        this.notifyMigrationAwarePublishers(p -> p.onMigrationCommit(event));
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        this.notifyMigrationAwarePublishers(p -> p.onMigrationRollback(event));
    }

    private ConcurrentHashMap<String, DelegatingWanScheme> getWanReplications() {
        return this.wanReplicationService.getWanReplications();
    }

    private void notifyMigrationAwarePublishers(Consumer<WanMigrationAwarePublisher> publisherConsumer) {
        ConcurrentHashMap<String, DelegatingWanScheme> wanReplications = this.getWanReplications();
        for (DelegatingWanScheme wanReplication : wanReplications.values()) {
            for (WanPublisher publisher : wanReplication.getPublishers()) {
                if (!(publisher instanceof WanMigrationAwarePublisher)) continue;
                publisherConsumer.accept((WanMigrationAwarePublisher)((Object)publisher));
            }
        }
    }
}

