/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl;

import com.hazelcast.enterprise.wan.impl.DistributedObjectEntryIdentifier;
import com.hazelcast.enterprise.wan.impl.FinalizableEnterpriseWanEvent;
import com.hazelcast.enterprise.wan.impl.TwoPhasedLinkedQueue;
import com.hazelcast.internal.serialization.SerializableByConvention;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.wan.impl.InternalWanEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;

@SerializableByConvention(value=SerializableByConvention.Reason.PUBLIC_API)
public class WanEventQueue
extends TwoPhasedLinkedQueue<FinalizableEnterpriseWanEvent>
implements DataSerializable {
    private int backupCount;

    public WanEventQueue(int backupCount, int queueForceFinalizationThreshold) {
        super(queueForceFinalizationThreshold);
        this.backupCount = backupCount;
    }

    public WanEventQueue() {
    }

    public int getBackupCount() {
        return this.backupCount;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        ArrayList<InternalWanEvent> events = this.collectWanEvents();
        out.writeInt(this.backupCount);
        out.writeInt(events.size());
        for (InternalWanEvent event : events) {
            out.writeObject(event);
        }
    }

    private ArrayList<InternalWanEvent> collectWanEvents() {
        LinkedHashMap eventMap = new LinkedHashMap();
        LinkedList queueElements = new LinkedList();
        this.consumeAll(queueElements::add, event -> {
            DistributedObjectEntryIdentifier id = new DistributedObjectEntryIdentifier(event.getServiceName(), event.getObjectName(), event.getKey());
            eventMap.put(id, event);
        });
        ArrayList<InternalWanEvent> events = new ArrayList<InternalWanEvent>(eventMap.size() + queueElements.size());
        events.addAll(((HashMap)eventMap).values());
        events.addAll(queueElements);
        return events;
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.backupCount = in.readInt();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            InternalWanEvent event = (InternalWanEvent)in.readObject();
            if (event.getServiceName() == null) continue;
            this.offer(new FinalizableEnterpriseWanEvent(event));
        }
    }
}

