/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl;

import com.hazelcast.enterprise.wan.impl.FinalizableEnterpriseWanEvent;
import com.hazelcast.enterprise.wan.impl.WanEventQueue;
import com.hazelcast.internal.serialization.SerializableByConvention;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.wan.impl.InternalWanEvent;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@SerializableByConvention(value=SerializableByConvention.Reason.PUBLIC_API)
public class PartitionWanEventQueueMap
extends ConcurrentHashMap<String, WanEventQueue>
implements DataSerializable {
    private static final long serialVersionUID = 1L;
    private final transient Object mutex = new Object();
    private final transient int maxInFlightEvents;

    public PartitionWanEventQueueMap() {
        this(Integer.MAX_VALUE);
    }

    public PartitionWanEventQueueMap(int maxInFlightEvents) {
        this.maxInFlightEvents = maxInFlightEvents;
    }

    public boolean offerEvent(FinalizableEnterpriseWanEvent wanReplicationEvent, String distributedObjectName, int backupCount) {
        return this.getOrCreateEventQueue(distributedObjectName, backupCount).offer(wanReplicationEvent);
    }

    public InternalWanEvent pollEvent(String distributedObjectName) {
        WanEventQueue eventQueue = (WanEventQueue)this.get(distributedObjectName);
        if (eventQueue != null) {
            return (InternalWanEvent)eventQueue.poll();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WanEventQueue getOrCreateEventQueue(String distributedObjectName, int backupCount) {
        WanEventQueue eventQueue = (WanEventQueue)this.get(distributedObjectName);
        if (eventQueue == null) {
            Object object = this.mutex;
            synchronized (object) {
                eventQueue = (WanEventQueue)this.get(distributedObjectName);
                if (eventQueue == null) {
                    eventQueue = new WanEventQueue(backupCount, this.maxInFlightEvents);
                    this.put(distributedObjectName, eventQueue);
                }
            }
        }
        return eventQueue;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.size());
        for (Map.Entry entry : this.entrySet()) {
            out.writeString((String)entry.getKey());
            out.writeObject(entry.getValue());
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            String name = in.readString();
            WanEventQueue queue = (WanEventQueue)in.readObject();
            this.put(name, queue);
        }
    }
}

