/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.wan.impl;

import com.hazelcast.enterprise.wan.impl.AbstractWanEventRunnable;
import com.hazelcast.enterprise.wan.impl.WanAcknowledger;
import com.hazelcast.enterprise.wan.impl.operation.WanAcknowledgeCompactSchemaReplicationsOperation;
import com.hazelcast.enterprise.wan.impl.operation.WanEventContainerOperation;
import com.hazelcast.enterprise.wan.impl.replication.WanEventBatch;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.internal.serialization.impl.compact.schema.MemberSchemaService;
import com.hazelcast.internal.services.WanSupportingService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.wan.WanEnterpriseMapMerkleTreeNode;
import com.hazelcast.map.impl.wan.WanEnterpriseMapSyncEvent;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.wan.WanEvent;
import com.hazelcast.wan.WanEventCounters;
import com.hazelcast.wan.impl.InternalWanEvent;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;

class BatchWanEventRunnable
extends AbstractWanEventRunnable {
    private final WanEventBatch batchEvent;
    private final NodeEngine nodeEngine;
    private final Set<Operation> liveOperations;
    private final ILogger logger;
    private final WanAcknowledger acknowledger;
    private final Executor executor;

    BatchWanEventRunnable(WanEventBatch batchEvent, WanEventContainerOperation operation, NodeEngine nodeEngine, Set<Operation> liveOperations, ILogger logger, WanAcknowledger acknowledger, Executor executor) {
        super(operation);
        this.batchEvent = batchEvent;
        this.nodeEngine = nodeEngine;
        this.liveOperations = liveOperations;
        this.logger = logger;
        this.acknowledger = acknowledger;
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            String syncServiceName;
            List<Schema> schemas = this.batchEvent.getCompactSchemas();
            if (schemas != null && !schemas.isEmpty()) {
                MemberSchemaService schemaService = this.nodeEngine.getSchemaService();
                for (Schema schema : schemas) {
                    schemaService.put(schema);
                }
                this.sendAckForReplicatedSchemas(schemas);
            }
            if ((syncServiceName = (String)this.batchEvent.getEvents().stream().findAny().filter(anyWanEvent -> anyWanEvent instanceof WanEnterpriseMapSyncEvent || anyWanEvent instanceof WanEnterpriseMapMerkleTreeNode).map(WanEvent::getServiceName).orElse(null)) != null) {
                this.handleSync(syncServiceName);
            } else {
                this.handleRepl();
            }
        }
        catch (Exception e) {
            this.handleFailure(e);
        }
        finally {
            if (!this.liveOperations.remove(this.operation)) {
                this.logger.warning("Did not remove WanOperation from live operation list. Possible memory leak!");
            }
        }
    }

    private void handleFailure(Throwable t) {
        this.log(this.logger, t);
        this.acknowledger.acknowledgeFailure(this.operation);
    }

    private void handleRepl() {
        for (InternalWanEvent wanEvent : this.batchEvent.getEvents()) {
            String serviceName = wanEvent.getServiceName();
            WanSupportingService service = (WanSupportingService)this.nodeEngine.getService(serviceName);
            service.onReplicationEvent(wanEvent, this.operation.getAcknowledgeType());
        }
        this.acknowledger.acknowledgeSuccess(this.operation);
    }

    private void handleSync(String syncServiceName) {
        WanSupportingService service = (WanSupportingService)this.nodeEngine.getService(syncServiceName);
        CompletionStage<Void> future = service.onSyncBatch(this.batchEvent.getEvents(), this.operation.getAcknowledgeType());
        future.whenCompleteAsync((unused, throwable) -> {
            if (throwable != null) {
                this.handleFailure((Throwable)throwable);
            } else {
                this.incrementSyncCountersAndAcknowledgeSync();
            }
        }, this.executor);
    }

    private void incrementSyncCountersAndAcknowledgeSync() {
        try {
            WanEventCounters wanEventCounters = this.nodeEngine.getWanReplicationService().getReceivedEventCounters("hz:impl:mapService");
            this.batchEvent.getEvents().forEach(e -> {
                if (e instanceof WanEnterpriseMapSyncEvent) {
                    wanEventCounters.incrementSync(((WanEnterpriseMapSyncEvent)e).getMapName());
                } else if (e instanceof WanEnterpriseMapMerkleTreeNode) {
                    WanEnterpriseMapMerkleTreeNode node = (WanEnterpriseMapMerkleTreeNode)e;
                    wanEventCounters.incrementSync(node.getMapName(), node.getEntryCount());
                }
            });
            this.acknowledger.acknowledgeSuccess(this.operation);
        }
        catch (Exception e2) {
            this.handleFailure(e2);
        }
    }

    private void sendAckForReplicatedSchemas(List<Schema> schemas) {
        List<Long> schemaIds = schemas.stream().map(Schema::getSchemaId).collect(Collectors.toList());
        UUID clusterId = this.nodeEngine.getClusterService().getClusterId();
        String clusterIdString = clusterId == null ? null : clusterId.toString();
        this.nodeEngine.getOperationService().createInvocationBuilder(this.operation.getServiceName(), (Operation)new WanAcknowledgeCompactSchemaReplicationsOperation(clusterIdString, schemaIds), this.operation.getCallerAddress()).setConnectionManager(this.operation.getConnection().getConnectionManager()).setTryCount(1).invoke();
    }
}

