/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.persistence.operation;

import com.hazelcast.cp.CPMember;
import com.hazelcast.cp.internal.RaftService;
import com.hazelcast.cp.internal.RaftSystemOperation;
import com.hazelcast.cp.internal.persistence.CPPersistenceDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.impl.RaftInvocationContext;
import java.io.IOException;

public class PublishLocalCPMemberOp
extends Operation
implements IdentifiedDataSerializable,
RaftSystemOperation {
    private CPMember localMember;

    public PublishLocalCPMemberOp() {
    }

    public PublishLocalCPMemberOp(CPMember localMember) {
        this.localMember = localMember;
    }

    @Override
    public void run() {
        RaftService service = (RaftService)this.getService();
        RaftInvocationContext raftInvocationContext = service.getInvocationManager().getRaftInvocationContext();
        raftInvocationContext.updateMember(this.localMember);
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public String getServiceName() {
        return "hz:core:raft";
    }

    @Override
    public int getFactoryId() {
        return CPPersistenceDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 2;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.localMember);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.localMember = (CPMember)in.readObject();
    }

    @Override
    protected void toString(StringBuilder sb) {
        sb.append(", member=").append(this.localMember);
    }
}

