/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.persistence;

import com.hazelcast.cp.internal.raft.exception.LogValidationException;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.ObjectDataInputStream;
import com.hazelcast.internal.serialization.impl.ObjectDataOutputStream;
import com.hazelcast.internal.util.Preconditions;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import javax.annotation.Nonnull;

public class BufferedRaf
implements Closeable {
    static final int BUFFER_SIZE = 16384;
    private final RandomAccessFile raf;
    private final byte[] buf = new byte[16384];
    private final ByteBuffer auxBuf = ByteBuffer.wrap(new byte[8]);
    private Mode mode;
    private long fileLength;
    private long bufBaseFileOffset;
    private int bufLimit;
    private long filePointer;

    BufferedRaf(RandomAccessFile raf) throws IOException {
        this.raf = raf;
        this.fileLength = raf.length();
    }

    public BufferedRaf(File file) throws IOException {
        this(new RandomAccessFile(file, "rw"));
    }

    public BufRafObjectDataOut asObjectDataOutputStream(InternalSerializationService serializationService) {
        return new BufRafObjectDataOut(new BufRafOutputStream(), serializationService);
    }

    public BufRafObjectDataIn asObjectDataInputStream(InternalSerializationService serializationService) {
        return new BufRafObjectDataIn(new BufRafInputStream(), serializationService);
    }

    public long length() {
        return this.fileLength;
    }

    public void setLength(long newLength) throws IOException {
        this.flush();
        this.raf.setLength(newLength);
        this.fileLength = newLength;
    }

    public long filePointer() {
        return this.filePointer;
    }

    public void flush() throws IOException {
        if (this.mode == Mode.WRITING) {
            this.flushBuffer();
        }
    }

    public void force() throws IOException {
        this.flush();
        this.raf.getFD().sync();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.raf.close();
    }

    public void seek(long offset) {
        Preconditions.checkNotNegative(offset, "Asked to seek to a negative file offset ");
        this.filePointer = offset;
    }

    public void skipBytes(long length) {
        this.seek(this.filePointer + length);
    }

    public void read(byte[] buffer, int start, int count) throws IOException {
        if (start + count > buffer.length) {
            throw new IllegalArgumentException("Requested to read more than fits into the buffer");
        }
        this.ensure(Mode.READING);
        if (this.filePointer + (long)count > this.fileLength) {
            throw new IllegalArgumentException("Requested to read beyond the end of file");
        }
        this.fillBufferIfNeeded();
        int bytesRead = 0;
        while (true) {
            int srcOffset = (int)(this.filePointer - this.bufBaseFileOffset);
            int bytesToCopy = Math.min(count - bytesRead, this.bufLimit - srcOffset);
            System.arraycopy(this.buf, srcOffset, buffer, start + bytesRead, bytesToCopy);
            this.filePointer += (long)bytesToCopy;
            if ((bytesRead += bytesToCopy) == count) {
                return;
            }
            this.fillBuffer();
        }
    }

    public void copyTo(BufferedRaf dest) throws IOException {
        this.ensure(Mode.READING);
        this.fillBufferIfNeeded();
        while (this.filePointer != this.fileLength) {
            int srcOffset = (int)(this.filePointer - this.bufBaseFileOffset);
            int bytesToCopy = Math.min((int)(this.fileLength - this.filePointer), this.bufLimit - srcOffset);
            dest.write(this.buf, srcOffset, bytesToCopy);
            this.filePointer += (long)bytesToCopy;
            this.fillBuffer();
        }
    }

    private void fillBufferIfNeeded() throws IOException {
        long bufOffset = this.filePointer - this.bufBaseFileOffset;
        if (bufOffset < 0L || bufOffset > (long)this.bufLimit) {
            this.fillBuffer();
        }
    }

    public void write(@Nonnull byte[] bytes, int start, int count) throws IOException {
        int copySize;
        this.ensure(Mode.WRITING);
        if (this.filePointer != this.bufBaseFileOffset + (long)this.bufLimit) {
            this.flushBuffer();
            this.bufBaseFileOffset = this.filePointer;
        }
        if (this.filePointer + (long)count > this.fileLength) {
            this.fileLength = this.filePointer + (long)count;
        }
        int doneCount = 0;
        do {
            copySize = Math.min(count - doneCount, this.buf.length - this.bufLimit);
            System.arraycopy(bytes, start + doneCount, this.buf, this.bufLimit, copySize);
            this.bufLimit += copySize;
            if (this.bufLimit != this.buf.length) continue;
            this.flushBuffer();
        } while ((doneCount += copySize) != count);
        this.filePointer += (long)count;
    }

    public int readByte() throws IOException {
        this.read(this.auxBuf.array(), 0, 1);
        return this.auxBuf.get(0) & 0xFF;
    }

    public int readInt() throws IOException {
        this.read(this.auxBuf.array(), 0, 4);
        return this.auxBuf.getInt(0);
    }

    public long readLong() throws IOException {
        this.read(this.auxBuf.array(), 0, 8);
        return this.auxBuf.getLong(0);
    }

    public void writeByte(int b) throws IOException {
        this.auxBuf.put(0, (byte)b);
        this.write(this.auxBuf.array(), 0, 1);
    }

    public void writeInt(int value) throws IOException {
        this.auxBuf.putInt(0, value);
        this.write(this.auxBuf.array(), 0, 4);
    }

    public void writeLong(long value) throws IOException {
        this.auxBuf.putLong(0, value);
        this.write(this.auxBuf.array(), 0, 8);
    }

    public long available() {
        return this.fileLength - this.filePointer;
    }

    private void ensure(Mode requestedMode) throws IOException {
        if (this.mode == requestedMode) {
            return;
        }
        if (this.mode == Mode.WRITING) {
            this.flushBuffer();
        } else if (this.mode == Mode.READING) {
            this.bufLimit = 0;
        }
        this.mode = requestedMode;
    }

    private void flushBuffer() throws IOException {
        this.raf.seek(this.bufBaseFileOffset);
        this.raf.write(this.buf, 0, this.bufLimit);
        this.bufBaseFileOffset += (long)this.bufLimit;
        this.bufLimit = 0;
    }

    private void fillBuffer() throws IOException {
        int readCount;
        this.raf.seek(this.filePointer);
        this.bufLimit = Math.min(this.buf.length, (int)(this.fileLength - this.filePointer));
        int offset = 0;
        do {
            if ((readCount = this.raf.read(this.buf, offset, this.bufLimit - offset)) != -1) continue;
            throw new IOException("Unexpected EOF reached at " + this.raf.getFilePointer());
        } while ((offset += readCount) != this.bufLimit);
        this.bufBaseFileOffset = this.filePointer;
    }

    static class BufRafObjectDataOut
    extends ObjectDataOutputStream {
        private final BufRafOutputStream outputStream;

        BufRafObjectDataOut(BufRafOutputStream outputStream, InternalSerializationService serializationService) {
            super(outputStream, serializationService);
            this.outputStream = outputStream;
        }

        void writeCrc32() throws IOException {
            this.outputStream.writeCrc32();
        }
    }

    static class BufRafObjectDataIn
    extends ObjectDataInputStream {
        private final BufRafInputStream inputStream;

        BufRafObjectDataIn(BufRafInputStream inputStream, InternalSerializationService serializationService) {
            super(inputStream, serializationService);
            this.inputStream = inputStream;
        }

        void checkCrc32() throws IOException {
            this.inputStream.checkCrc32();
        }
    }

    private class BufRafOutputStream
    extends OutputStream {
        private final CRC32 crc32 = new CRC32();

        private BufRafOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            BufferedRaf.this.writeByte(b);
            this.crc32.update(b);
        }

        @Override
        public void write(@Nonnull byte[] b) throws IOException {
            BufferedRaf.this.write(b, 0, b.length);
            this.crc32.update(b);
        }

        @Override
        public void write(@Nonnull byte[] b, int off, int len) throws IOException {
            BufferedRaf.this.write(b, off, len);
            this.crc32.update(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            BufferedRaf.this.flush();
        }

        @Override
        public void close() throws IOException {
            BufferedRaf.this.close();
        }

        void writeCrc32() throws IOException {
            BufferedRaf.this.writeInt((int)this.crc32.getValue());
            this.crc32.reset();
        }
    }

    private class BufRafInputStream
    extends InputStream {
        private final CRC32 crc32 = new CRC32();

        private BufRafInputStream() {
        }

        @Override
        public int read() throws IOException {
            int b = BufferedRaf.this.readByte();
            this.crc32.update(b);
            return b;
        }

        @Override
        public int read(@Nonnull byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(@Nonnull byte[] b, int off, int len) throws IOException {
            int readCount = (int)Math.min((long)len, BufferedRaf.this.fileLength - BufferedRaf.this.filePointer);
            BufferedRaf.this.read(b, off, len);
            this.crc32.update(b, off, len);
            return readCount;
        }

        @Override
        public int available() {
            return (int)BufferedRaf.this.available();
        }

        @Override
        public void close() throws IOException {
            BufferedRaf.this.close();
        }

        void checkCrc32() throws IOException {
            if ((int)this.crc32.getValue() != BufferedRaf.this.readInt()) {
                throw new LogValidationException("CRC failure");
            }
            this.crc32.reset();
        }
    }

    private static enum Mode {
        READING,
        WRITING;

    }
}

