/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.operation;

import com.hazelcast.cache.impl.CachePartitionSegment;
import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.cache.impl.CacheStatisticsImpl;
import com.hazelcast.cache.impl.EnterpriseCachePartitionSegment;
import com.hazelcast.cache.impl.ICacheRecordStore;
import com.hazelcast.cache.impl.ICacheService;
import com.hazelcast.cache.impl.PreJoinCacheConfig;
import com.hazelcast.cache.impl.operation.CacheNearCacheStateHolder;
import com.hazelcast.cache.impl.operation.EnterpriseCacheDataSerializerHook;
import com.hazelcast.cache.impl.record.CacheRecord;
import com.hazelcast.cache.impl.record.CacheRecordReaderWriter;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.internal.monitor.impl.LocalReplicationStatsImpl;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.partition.MigrationCycleOperation;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.services.ObjectNamespace;
import com.hazelcast.internal.services.ServiceNamespace;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.internal.util.collection.IntHashSet;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.wan.impl.merkletree.MerkleTree;
import com.hazelcast.wan.impl.merkletree.MerkleTreeUtil;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;

public class EnterpriseCacheReplicationOperation
extends Operation
implements IdentifiedDataSerializable,
MigrationCycleOperation {
    private final transient Map<String, ICacheRecordStore> recordStores = new ConcurrentHashMap<String, ICacheRecordStore>();
    private final Map<String, int[]> cacheNameToDiff = new ConcurrentHashMap<String, int[]>();
    private final Set<PreJoinCacheConfig> configs = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<String, Queue> data = new HashMap<String, Queue>();
    private final transient Map<String, LocalReplicationStatsImpl> statsByCacheName = new ConcurrentHashMap<String, LocalReplicationStatsImpl>();
    private volatile CacheNearCacheStateHolder nearCacheStateHolder;
    private ILogger logger = Logger.getLogger(EnterpriseCacheReplicationOperation.class);

    public EnterpriseCacheReplicationOperation() {
        this.nearCacheStateHolder = new CacheNearCacheStateHolder();
        this.nearCacheStateHolder.setCacheReplicationOperation(this);
    }

    public final void prepare(CachePartitionSegment segment, Collection<ServiceNamespace> namespaces, int replicaIndex, Map<String, int[]> cacheNamesToMerkleDiff) {
        if (cacheNamesToMerkleDiff != null) {
            this.cacheNameToDiff.putAll(cacheNamesToMerkleDiff);
        }
        for (ServiceNamespace namespace : namespaces) {
            CacheConfig cacheConfig2;
            ObjectNamespace ns = (ObjectNamespace)namespace;
            ICacheRecordStore recordStore = segment.getRecordStore(ns.getObjectName());
            if (recordStore == null || (cacheConfig2 = recordStore.getConfig()).getTotalBackupCount() < replicaIndex) continue;
            this.recordStores.put(ns.getObjectName(), recordStore);
            CacheStatisticsImpl cacheStats = recordStore.getCacheStats();
            if (cacheStats == null) continue;
            this.statsByCacheName.put(recordStore.getName(), cacheStats.getReplicationStats());
        }
        segment.getCacheConfigs().forEach(cacheConfig -> this.configs.add(PreJoinCacheConfig.of(cacheConfig)));
        this.nearCacheStateHolder.prepare(segment, namespaces);
    }

    @Override
    public void beforeRun() {
        ICacheService service = (ICacheService)this.getService();
        for (CacheConfig cacheConfig : this.configs) {
            service.putCacheConfigIfAbsent(cacheConfig);
        }
    }

    @Override
    public void run() throws Exception {
        ICacheService service = (ICacheService)this.getService();
        for (Map.Entry<String, Queue> entry : this.data.entrySet()) {
            ICacheRecordStore recordStore = service.getOrCreateRecordStore(entry.getKey(), this.getPartitionId());
            this.initializeRecordStore(entry.getKey(), recordStore);
            Queue keyRecordPairs = entry.getValue();
            while (!keyRecordPairs.isEmpty() && !recordStore.evictIfRequired()) {
                Data key = (Data)keyRecordPairs.poll();
                CacheRecord record = (CacheRecord)keyRecordPairs.poll();
                recordStore.putRecord(key, record, false);
            }
        }
        this.data.clear();
        if (this.getReplicaIndex() == 0) {
            this.nearCacheStateHolder.applyState();
        }
    }

    @Override
    public String getServiceName() {
        return "hz:impl:cacheService";
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        int confSize = this.configs.size();
        out.writeInt(confSize);
        for (CacheConfig cacheConfig : this.configs) {
            out.writeObject(cacheConfig);
        }
        out.writeInt(this.recordStores.size());
        for (Map.Entry entry : this.recordStores.entrySet()) {
            String cacheName = (String)entry.getKey();
            out.writeString(cacheName);
            ICacheRecordStore recordStore = (ICacheRecordStore)entry.getValue();
            int[] diff = this.cacheNameToDiff.get(cacheName);
            if (diff == null) {
                out.writeBoolean(false);
                this.writeRecordStoreData(out, cacheName, recordStore);
                continue;
            }
            out.writeBoolean(true);
            this.writeDifferentialData(out, cacheName, recordStore, diff);
        }
        out.writeObject(this.nearCacheStateHolder);
    }

    private void writeRecordStoreData(ObjectDataOutput out, String cacheName, ICacheRecordStore recordStore) throws IOException {
        Map<Data, CacheRecord> data = recordStore.getReadOnlyRecords();
        out.writeInt(data.size());
        int countWrittenData = 0;
        for (Map.Entry<Data, CacheRecord> entry : data.entrySet()) {
            IOUtil.writeData(out, entry.getKey());
            CacheRecordReaderWriter.writeCacheRecord(entry.getValue(), out);
            ++countWrittenData;
        }
        IOUtil.writeData(out, null);
        LocalReplicationStatsImpl replicationStats = this.statsByCacheName.get(cacheName);
        if (replicationStats != null) {
            replicationStats.incrementFullPartitionReplicationCount();
            replicationStats.incrementFullPartitionReplicationRecordsCount(countWrittenData);
        }
    }

    private void writeDifferentialData(ObjectDataOutput out, String cacheName, ICacheRecordStore recordStore, int[] diff) throws IOException {
        LocalReplicationStatsImpl replicationStats;
        out.writeIntArray(diff);
        List entries = this.collectEntries(cacheName, recordStore, diff);
        out.writeInt(entries.size() / 2);
        int countWrittenData = 0;
        for (int i = 0; i < entries.size(); i += 2) {
            IOUtil.writeData(out, (Data)entries.get(i));
            CacheRecordReaderWriter.writeCacheRecord((CacheRecord)entries.get(i + 1), out);
            ++countWrittenData;
        }
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Differential sync for " + cacheName + " / " + recordStore.getPartitionId() + " transferred " + countWrittenData + " records");
        }
        if ((replicationStats = this.statsByCacheName.get(cacheName)) != null) {
            replicationStats.incrementDiffPartitionReplicationCount();
            replicationStats.incrementDiffPartitionReplicationRecordsCount(countWrittenData);
        }
    }

    private List collectEntries(String cacheName, ICacheRecordStore recordStore, int[] diff) {
        MerkleTree merkleTree = this.getMerkleTree(this.getPartitionId(), cacheName);
        if (merkleTree == null || diff == null || diff.length == 0) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList(diff.length / 2);
        this.forEachKeyOfNodes(recordStore, diff, (key, record) -> {
            result.add(key);
            result.add(record);
        });
        return result;
    }

    private void forEachKeyOfNodes(ICacheRecordStore recordStore, int[] diff, BiConsumer<Data, CacheRecord> consumer) {
        ThreadUtil.assertRunningOnPartitionThread();
        IntHashSet merkleTreeOrderValues = MerkleTreeUtil.setOfNodeOrders(diff);
        int levelOfRequestedNodes = MerkleTreeUtil.getLevelOfNode(diff[0]);
        Map<Data, CacheRecord> data = recordStore.getReadOnlyRecords();
        for (Map.Entry<Data, CacheRecord> entry : data.entrySet()) {
            Data dataKey = entry.getKey();
            int keyHash = dataKey.hashCode();
            int currentKeyNodeOrder = MerkleTreeUtil.getLeafOrderForHash(keyHash, levelOfRequestedNodes);
            if (!merkleTreeOrderValues.contains(currentKeyNodeOrder)) continue;
            consumer.accept(dataKey, entry.getValue());
        }
    }

    private MerkleTree getMerkleTree(int partitionId, String cacheName) {
        CacheService cacheService = (CacheService)this.getService();
        EnterpriseCachePartitionSegment segment = (EnterpriseCachePartitionSegment)cacheService.getSegment(partitionId);
        return segment.getMerkleTree(cacheName);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int confSize = in.readInt();
        for (int i = 0; i < confSize; ++i) {
            this.configs.add((PreJoinCacheConfig)in.readObject());
        }
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            String cacheName = in.readString();
            boolean differentialReplication = in.readBoolean();
            if (differentialReplication) {
                this.readDifferentialData(cacheName, in);
                continue;
            }
            this.readRecordStoreData(cacheName, in, false);
        }
        this.nearCacheStateHolder = (CacheNearCacheStateHolder)in.readObject();
        this.nearCacheStateHolder.setCacheReplicationOperation(this);
    }

    private void readDifferentialData(String cacheName, ObjectDataInput in) throws IOException {
        int[] diffNodeOrder = in.readIntArray();
        this.cacheNameToDiff.put(cacheName, diffNodeOrder);
        this.readRecordStoreData(cacheName, in, true);
    }

    private void readRecordStoreData(String cacheName, ObjectDataInput in, boolean differentialRead) throws IOException {
        Data dataKey;
        int numOfRecords = in.readInt();
        ArrayDeque<Object> keyRecord = new ArrayDeque<Object>(numOfRecords * 2);
        int loopCounter = differentialRead ? numOfRecords : numOfRecords + 1;
        for (int j = 0; j < loopCounter && (dataKey = IOUtil.readData(in)) != null && dataKey.dataSize() != 0; ++j) {
            CacheRecord record = CacheRecordReaderWriter.readCacheRecord(in);
            keyRecord.add(dataKey);
            keyRecord.add(record);
        }
        this.data.put(cacheName, keyRecord);
    }

    protected void initializeRecordStore(String cacheName, ICacheRecordStore recordStore) {
        int[] nodeOrders = this.cacheNameToDiff.get(cacheName);
        if (nodeOrders == null) {
            recordStore.reset();
            return;
        }
        if (nodeOrders.length > 0) {
            Data key;
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Applying differential sync for " + cacheName);
            }
            MerkleTree merkleTree = this.getMerkleTree(recordStore.getPartitionId(), cacheName);
            assert (merkleTree != null) : "MerkleTree was unexpectedly null";
            Queue keyRecordPairs = this.data.get(cacheName);
            ArrayDeque keysToRemove = new ArrayDeque();
            this.forEachKeyOfNodes(recordStore, nodeOrders, (k, r) -> {
                if (!keyRecordPairs.contains(k)) {
                    keysToRemove.add(k);
                }
            });
            while ((key = (Data)keysToRemove.poll()) != null) {
                recordStore.removeRecord(key);
            }
        }
    }

    @Override
    public int getFactoryId() {
        return EnterpriseCacheDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 4;
    }

    @Override
    public boolean requiresTenantContext() {
        return true;
    }
}

