/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.hotrestart;

import com.hazelcast.cache.impl.EnterpriseCacheRecordStore;
import com.hazelcast.cache.impl.EnterpriseCacheService;
import com.hazelcast.cache.impl.record.CacheRecord;
import com.hazelcast.cache.impl.record.CacheRecordHashMap;
import com.hazelcast.internal.hotrestart.HotRestartKey;
import com.hazelcast.internal.hotrestart.HotRestartStore;
import com.hazelcast.internal.hotrestart.KeyHandle;
import com.hazelcast.internal.hotrestart.RamStore;
import com.hazelcast.internal.hotrestart.RamStoreHelper;
import com.hazelcast.internal.hotrestart.RecordDataSink;
import com.hazelcast.internal.hotrestart.impl.KeyOnHeap;
import com.hazelcast.internal.hotrestart.impl.SetOfKeyHandle;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.impl.HeapData;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.spi.impl.NodeEngine;
import java.util.UUID;

public class HotRestartEnterpriseCacheRecordStore
extends EnterpriseCacheRecordStore
implements RamStore {
    private final long prefix;
    private final boolean fsync;
    private final HotRestartStore hotRestartStore;

    public HotRestartEnterpriseCacheRecordStore(String name, int partitionId, NodeEngine nodeEngine, EnterpriseCacheService cacheService, boolean fsync, long keyPrefix) {
        super(name, partitionId, nodeEngine, cacheService);
        this.fsync = fsync;
        this.prefix = keyPrefix;
        this.hotRestartStore = cacheService.onHeapHotRestartStoreForPartition(partitionId);
        assert (this.hotRestartStore != null);
    }

    @Override
    protected CacheRecord doPutRecord(Data key, CacheRecord record, UUID source, boolean updateJournal) {
        CacheRecord oldRecord = super.doPutRecord(key, record, source, updateJournal);
        this.putToHotRestart(key, record.getValue());
        return oldRecord;
    }

    @Override
    protected void onUpdateRecord(Data key, CacheRecord record, Object value, Data oldDataValue) {
        super.onUpdateRecord(key, record, value, oldDataValue);
        this.putToHotRestart(key, record.getValue());
    }

    @Override
    protected void onRemove(Data key, Object value, UUID source, boolean getValue, CacheRecord record, boolean removed) {
        super.onRemove(key, value, source, getValue, record, removed);
        if (removed) {
            this.removeFromHotRestart(key);
        }
    }

    @Override
    public CacheRecord removeRecord(Data key) {
        CacheRecord record = super.removeRecord(key);
        if (record != null) {
            this.removeFromHotRestart(key);
        }
        return record;
    }

    @Override
    public void onEvict(Data key, CacheRecord record, boolean wasExpired) {
        super.onEvict(key, record, wasExpired);
        this.removeFromHotRestart(key);
    }

    @Override
    protected void onProcessExpiredEntry(Data key, CacheRecord record, long expiryTime, long now, UUID source, UUID origin) {
        super.onProcessExpiredEntry(key, record, expiryTime, now, source, origin);
        this.removeFromHotRestart(key);
    }

    @Override
    public boolean copyEntry(KeyHandle kh, int expectedSize, RecordDataSink sink) {
        KeyOnHeap keyHandle = (KeyOnHeap)kh;
        byte[] keyBytes = keyHandle.bytes();
        HeapData key = new HeapData(keyBytes);
        CacheRecord record = (CacheRecord)((CacheRecordHashMap)this.records).get(key);
        if (record == null) {
            return false;
        }
        Data value = this.toData(record.getValue());
        return RamStoreHelper.copyEntry(keyHandle, value, expectedSize, sink);
    }

    @Override
    public KeyOnHeap toKeyHandle(byte[] key) {
        return new KeyOnHeap(this.prefix, key);
    }

    @Override
    public void accept(KeyHandle kh, byte[] valueBytes) {
        HeapData key = new HeapData(((KeyOnHeap)kh).bytes());
        HeapData value = new HeapData(valueBytes);
        Object record = this.cacheRecordFactory.newRecordWithExpiry(value, Clock.currentTimeMillis(), -1L);
        ((CacheRecordHashMap)this.records).put(key, (CacheRecord)record);
    }

    private void putToHotRestart(Data key, Object value) {
        byte[] valueBytes = this.serializationService.toData(value).toByteArray();
        HotRestartKey kh = this.createHotRestartKey(key);
        this.hotRestartStore.put(kh, valueBytes, this.fsync);
    }

    private void removeFromHotRestart(Data key) {
        this.hotRestartStore.remove(this.createHotRestartKey(key), this.fsync);
    }

    @Override
    public void removeNullEntries(SetOfKeyHandle keyHandles) {
    }

    @Override
    public void reset() {
        this.resetInternal(true);
    }

    private void resetInternal(boolean clearHotRestartStore) {
        if (clearHotRestartStore) {
            this.hotRestartStore.clear(this.fsync, this.prefix);
        }
        super.reset();
    }

    @Override
    public void close(boolean onShutdown) {
        this.resetInternal(false);
        this.destroyEventJournal();
        this.closeListeners();
    }

    public HotRestartKey createHotRestartKey(Data key) {
        return new KeyOnHeap(this.prefix, key.toByteArray());
    }
}

