/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.hidensity.operation;

import com.hazelcast.cache.HazelcastExpiryPolicy;
import com.hazelcast.cache.impl.hidensity.operation.BackupAwareHiDensityCacheOperation;
import com.hazelcast.cache.impl.hidensity.operation.CachePutBackupOperation;
import com.hazelcast.cache.impl.hidensity.operation.HiDensityCacheDataSerializerHook;
import com.hazelcast.cache.impl.operation.MutableOperation;
import com.hazelcast.cache.impl.record.CacheRecord;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.merge.CacheMergingEntryImpl;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import com.hazelcast.spi.merge.SplitBrainMergeTypes;
import com.hazelcast.wan.impl.CallerProvenance;
import java.io.IOException;
import javax.cache.expiry.ExpiryPolicy;

public class WanCacheMergeOperation
extends BackupAwareHiDensityCacheOperation
implements MutableOperation {
    private CacheMergingEntryImpl mergingEntry;
    private SplitBrainMergePolicy<Object, SplitBrainMergeTypes.CacheMergeTypes<Object, Object>, Object> mergePolicy;

    public WanCacheMergeOperation() {
    }

    public WanCacheMergeOperation(String name, SplitBrainMergePolicy<Object, SplitBrainMergeTypes.CacheMergeTypes<Object, Object>, Object> mergePolicy, SplitBrainMergeTypes.CacheMergeTypes mergingEntry, int completionId) {
        super(name, completionId);
        assert (mergingEntry instanceof CacheMergingEntryImpl);
        this.mergingEntry = (CacheMergingEntryImpl)mergingEntry;
        this.mergePolicy = mergePolicy;
    }

    @Override
    public void runInternal() {
        if (this.recordStore.merge(this.mergingEntry, this.mergePolicy, CallerProvenance.WAN) != null) {
            this.response = true;
        }
    }

    @Override
    public boolean shouldBackup() {
        return Boolean.TRUE.equals(this.response) && this.recordStore.getRecord(this.mergingEntry.getRawKey()) != null;
    }

    @Override
    public Operation getBackupOperation() {
        ExpiryPolicy expiryPolicy = WanCacheMergeOperation.createOrNullBackupExpiryPolicy(this.mergingEntry.getExpirationTime());
        CacheRecord record = this.recordStore.getRecord(this.mergingEntry.getRawKey());
        return new CachePutBackupOperation(this.name, this.mergingEntry.getRawKey(), this.mergingEntry.getRawValue(), expiryPolicy, record.getCreationTime(), true);
    }

    static ExpiryPolicy createOrNullBackupExpiryPolicy(long expiryTime) {
        if (expiryTime <= 0L) {
            return null;
        }
        long ttl = expiryTime - Clock.currentTimeMillis();
        if (ttl <= 0L) {
            return null;
        }
        return new HazelcastExpiryPolicy(ttl, 0L, 0L);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.mergingEntry);
        out.writeObject(this.mergePolicy);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.mergingEntry = (CacheMergingEntryImpl)in.readObject();
        this.mergePolicy = (SplitBrainMergePolicy)in.readObject();
    }

    @Override
    public int getClassId() {
        return 23;
    }

    @Override
    public int getFactoryId() {
        return HiDensityCacheDataSerializerHook.F_ID;
    }
}

