/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.hidensity.operation;

import com.hazelcast.cache.impl.hidensity.operation.BackupAwareKeyBasedHiDensityCacheOperation;
import com.hazelcast.cache.impl.hidensity.operation.CachePutBackupOperation;
import com.hazelcast.cache.impl.operation.MutableOperation;
import com.hazelcast.cache.impl.record.CacheRecord;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.MutatingOperation;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import javax.cache.expiry.ExpiryPolicy;

public class CachePutOperation
extends BackupAwareKeyBasedHiDensityCacheOperation
implements MutableOperation,
MutatingOperation {
    private Data value;
    private boolean get;
    private ExpiryPolicy expiryPolicy;

    public CachePutOperation() {
    }

    public CachePutOperation(String name, Data key, Data value, ExpiryPolicy expiryPolicy) {
        super(name, key);
        this.value = value;
        this.expiryPolicy = expiryPolicy;
        this.get = false;
    }

    public CachePutOperation(String name, Data key, Data value, ExpiryPolicy expiryPolicy, boolean get) {
        super(name, key);
        this.value = value;
        this.expiryPolicy = expiryPolicy;
        this.get = get;
    }

    @Override
    protected void runInternal() {
        if (this.get) {
            this.response = this.recordStore.getAndPut(this.key, this.value, this.expiryPolicy, this.getCallerUuid(), this.completionId);
        } else {
            this.recordStore.put(this.key, this.value, this.expiryPolicy, this.getCallerUuid(), this.completionId);
            this.response = null;
        }
    }

    @Override
    public void afterRun() throws Exception {
        if (this.recordStore.isWanReplicationEnabled()) {
            this.publishWanUpdate(this.key, this.recordStore.getRecord(this.key));
        }
        super.afterRun();
    }

    @Override
    protected void disposeInternal(EnterpriseSerializationService serializationService) {
        if (!this.runCompleted) {
            serializationService.disposeData(this.key);
            serializationService.disposeData(this.value);
        }
    }

    @Override
    public boolean shouldBackup() {
        return this.recordStore.getRecord(this.key) != null;
    }

    @Override
    public Operation getBackupOperation() {
        CacheRecord record = this.recordStore.getRecord(this.key);
        return new CachePutBackupOperation(this.name, this.key, this.value, this.expiryPolicy, record.getCreationTime());
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeBoolean(this.get);
        out.writeObject(this.expiryPolicy);
        IOUtil.writeData(out, this.value);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.get = in.readBoolean();
        this.expiryPolicy = (ExpiryPolicy)in.readObject();
        this.value = CachePutOperation.readNativeMemoryOperationData(in);
    }

    @Override
    public int getClassId() {
        return 2;
    }
}

