/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.hidensity.operation;

import com.hazelcast.cache.impl.hidensity.operation.BackupAwareHiDensityCacheOperation;
import com.hazelcast.cache.impl.hidensity.operation.CacheBackupRecordStore;
import com.hazelcast.cache.impl.hidensity.operation.CachePutAllBackupOperation;
import com.hazelcast.cache.impl.hidensity.operation.HiDensityCacheDataSerializerHook;
import com.hazelcast.cache.impl.operation.MutableOperation;
import com.hazelcast.cache.impl.record.CacheRecord;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.DataType;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.MutatingOperation;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.cache.expiry.ExpiryPolicy;

public class CachePutAllOperation
extends BackupAwareHiDensityCacheOperation
implements MutableOperation,
MutatingOperation {
    private List<Map.Entry<Data, Data>> entries;
    private ExpiryPolicy expiryPolicy;
    private transient CacheBackupRecordStore cacheBackupRecordStore;

    public CachePutAllOperation() {
    }

    public CachePutAllOperation(String name, List<Map.Entry<Data, Data>> entries, ExpiryPolicy expiryPolicy) {
        super(name);
        this.entries = entries;
        this.expiryPolicy = expiryPolicy;
    }

    @Override
    protected void beforeRunInternal() {
        super.beforeRunInternal();
        int backups = this.getSyncBackupCount() + this.getAsyncBackupCount();
        if (backups > 0) {
            this.cacheBackupRecordStore = new CacheBackupRecordStore(this.entries.size());
        }
    }

    @Override
    protected void runInternal() {
        UUID callerUuid = this.getCallerUuid();
        Iterator<Map.Entry<Data, Data>> iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry<Data, Data> entry = iterator.next();
            Data key = entry.getKey();
            Data value = entry.getValue();
            CacheRecord record = this.recordStore.put(key, value, this.expiryPolicy, callerUuid, this.completionId);
            Data onHeapKey = null;
            Data onHeapValue = null;
            if (this.cacheBackupRecordStore != null && record != null) {
                onHeapKey = (Data)this.serializationService.convertData(key, DataType.HEAP);
                onHeapValue = (Data)this.serializationService.convertData(value, DataType.HEAP);
                this.cacheBackupRecordStore.addBackupRecord(onHeapKey, onHeapValue, record.getCreationTime());
            }
            if (onHeapValue != null) {
                this.publishWanUpdate(onHeapKey, onHeapValue, record);
            } else {
                this.publishWanUpdate(onHeapKey, record);
            }
            iterator.remove();
        }
    }

    @Override
    protected void disposeInternal(EnterpriseSerializationService serializationService) {
        Iterator<Map.Entry<Data, Data>> iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry<Data, Data> entry = iterator.next();
            Data key = entry.getKey();
            Data value = entry.getValue();
            serializationService.disposeData(key);
            serializationService.disposeData(value);
            iterator.remove();
        }
    }

    @Override
    public boolean shouldBackup() {
        return this.cacheBackupRecordStore != null && !this.cacheBackupRecordStore.isEmpty();
    }

    @Override
    public Operation getBackupOperation() {
        return new CachePutAllBackupOperation(this.name, this.cacheBackupRecordStore, this.expiryPolicy);
    }

    @Override
    public int getClassId() {
        return 20;
    }

    @Override
    public int getFactoryId() {
        return HiDensityCacheDataSerializerHook.F_ID;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.expiryPolicy);
        out.writeInt(this.entries.size());
        for (Map.Entry<Data, Data> entry : this.entries) {
            IOUtil.writeData(out, entry.getKey());
            IOUtil.writeData(out, entry.getValue());
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.expiryPolicy = (ExpiryPolicy)in.readObject();
        int size = in.readInt();
        this.entries = new ArrayList<Map.Entry<Data, Data>>(size);
        for (int i = 0; i < size; ++i) {
            Data key = CachePutAllOperation.readNativeMemoryOperationData(in);
            Data value = CachePutAllOperation.readNativeMemoryOperationData(in);
            this.entries.add(new AbstractMap.SimpleImmutableEntry<Data, Data>(key, value));
        }
    }
}

