/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.cdc.impl;

import com.hazelcast.jet.cdc.ParsingException;
import com.hazelcast.jet.cdc.RecordPart;
import com.hazelcast.jet.json.JsonUtil;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

class RecordPartImpl
implements RecordPart {
    private String json;
    private final transient Supplier<String> jsonSupplier;
    private Map<String, Object> content;

    RecordPartImpl(@Nonnull Supplier<String> json) {
        this.jsonSupplier = Objects.requireNonNull(json);
    }

    RecordPartImpl(@Nonnull String json) {
        this.json = Objects.requireNonNull(json);
        this.jsonSupplier = null;
    }

    @Override
    @Nonnull
    public <T> T toObject(@Nonnull Class<T> clazz) throws ParsingException {
        Objects.requireNonNull(clazz, "class");
        try {
            Object t = JsonUtil.beanFrom((String)this.toJson(), clazz);
            if (t == null) {
                throw new ParsingException(String.format("Mapping %s as %s didn't yield a result", this.json, clazz.getName()));
            }
            return (T)t;
        }
        catch (IOException e) {
            throw new ParsingException(e.getMessage(), e);
        }
    }

    @Override
    @Nonnull
    public Map<String, Object> toMap() throws ParsingException {
        if (this.content == null) {
            try {
                this.content = JsonUtil.mapFrom((Object)this.toJson());
                if (this.content == null) {
                    throw new ParsingException(String.format("Parsing %s didn't yield a result", this.json));
                }
            }
            catch (IOException e) {
                throw new ParsingException(e.getMessage(), e);
            }
        }
        return this.content;
    }

    @Override
    @Nonnull
    public String toJson() {
        if (this.json == null && this.jsonSupplier != null) {
            this.json = this.jsonSupplier.get();
        }
        return Objects.requireNonNull(this.json, "RecordPart.json must not be null");
    }

    public int hashCode() {
        return this.toJson().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RecordPartImpl other = (RecordPartImpl)obj;
        return Objects.equals(this.toJson(), other.toJson());
    }

    public String toString() {
        return this.toJson();
    }
}

