/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.grpc.impl;

import com.hazelcast.jet.grpc.impl.StatusExceptionJet;
import com.hazelcast.jet.grpc.impl.StatusRuntimeExceptionJet;
import com.hazelcast.logging.ILogger;
import io.grpc.ManagedChannel;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import java.util.concurrent.TimeUnit;

public final class GrpcUtil {
    private GrpcUtil() {
    }

    public static Throwable translateGrpcException(Throwable exception) {
        if (exception instanceof StatusException) {
            return new StatusExceptionJet((StatusException)exception);
        }
        if (exception instanceof StatusRuntimeException) {
            return new StatusRuntimeExceptionJet((StatusRuntimeException)exception);
        }
        return exception;
    }

    public static void shutdownChannel(ManagedChannel channel, ILogger logger, long timeout) throws InterruptedException {
        if (!channel.shutdown().awaitTermination(timeout, TimeUnit.SECONDS)) {
            logger.info("gRPC client has not shut down within " + timeout + " seconds, you can override the timeout by setting the `jet.grpc.shutdown.timeout.seconds` system property");
            if (!channel.shutdownNow().awaitTermination(1L, TimeUnit.SECONDS)) {
                logger.info("gRPC client has not shut down on time, even after forceful shutdown");
            }
        }
    }
}

