/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.client.ml.job.config.Job;
import org.elasticsearch.client.ml.job.process.ModelSnapshot;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class UpdateModelSnapshotRequest
extends ActionRequest
implements ToXContentObject {
    public static final ConstructingObjectParser<UpdateModelSnapshotRequest, Void> PARSER = new ConstructingObjectParser("update_model_snapshot_request", a -> new UpdateModelSnapshotRequest((String)a[0], (String)a[1]));
    private final String jobId;
    private String snapshotId;
    private String description;
    private Boolean retain;

    public UpdateModelSnapshotRequest(String jobId, String snapshotId) {
        this.jobId = Objects.requireNonNull(jobId, "[" + Job.ID + "] must not be null");
        this.snapshotId = Objects.requireNonNull(snapshotId, "[" + ModelSnapshot.SNAPSHOT_ID + "] must not be null");
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getRetain() {
        return this.retain;
    }

    public void setRetain(boolean retain) {
        this.retain = retain;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Job.ID.getPreferredName(), this.jobId);
        builder.field(ModelSnapshot.SNAPSHOT_ID.getPreferredName(), this.snapshotId);
        if (this.description != null) {
            builder.field(ModelSnapshot.DESCRIPTION.getPreferredName(), this.description);
        }
        if (this.retain != null) {
            builder.field(ModelSnapshot.RETAIN.getPreferredName(), this.retain);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UpdateModelSnapshotRequest request = (UpdateModelSnapshotRequest)obj;
        return Objects.equals(this.jobId, request.jobId) && Objects.equals(this.snapshotId, request.snapshotId) && Objects.equals(this.description, request.description) && Objects.equals(this.retain, request.retain);
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.snapshotId, this.description, this.retain);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), Job.ID);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), ModelSnapshot.SNAPSHOT_ID);
        PARSER.declareStringOrNull(UpdateModelSnapshotRequest::setDescription, ModelSnapshot.DESCRIPTION);
        PARSER.declareBoolean(UpdateModelSnapshotRequest::setRetain, ModelSnapshot.RETAIN);
    }
}

