/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.elastic.impl;

import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.elastic.impl.ElasticSourceConfiguration;
import com.hazelcast.jet.elastic.impl.ElasticSourceP;
import com.hazelcast.jet.elastic.impl.Shard;
import com.hazelcast.jet.impl.util.Util;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;

class ElasticSourcePSupplier<T>
implements ProcessorSupplier {
    private static final long serialVersionUID = 1L;
    private final ElasticSourceConfiguration<T> configuration;
    private final List<Shard> shards;
    private Map<Integer, List<Shard>> shardsByProcessor;

    ElasticSourcePSupplier(@Nonnull ElasticSourceConfiguration<T> configuration, @Nonnull List<Shard> shards) {
        this.configuration = Objects.requireNonNull(configuration);
        this.shards = Objects.requireNonNull(shards);
    }

    public void init(@Nonnull ProcessorSupplier.Context context) {
        if (this.configuration.isCoLocatedReadingEnabled()) {
            if (this.configuration.isSlicingEnabled()) {
                this.shardsByProcessor = new HashMap<Integer, List<Shard>>();
                for (int i = 0; i < context.localParallelism(); ++i) {
                    this.shardsByProcessor.put(i, this.shards);
                }
            } else {
                this.shardsByProcessor = Util.distributeObjects((int)context.localParallelism(), this.shards);
            }
        }
    }

    @Nonnull
    public Collection<? extends Processor> get(int count) {
        return IntStream.range(0, count).mapToObj(i -> this.configuration.isCoLocatedReadingEnabled() ? new ElasticSourceP<T>(this.configuration, this.shardsByProcessor.get(i)) : new ElasticSourceP<T>(this.configuration, Collections.emptyList())).collect(Collectors.toList());
    }
}

