/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.elastic;

import javax.annotation.Nonnull;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;

public final class ElasticClients {
    private static final int DEFAULT_PORT = 9200;

    private ElasticClients() {
    }

    @Nonnull
    public static RestClientBuilder client() {
        return ElasticClients.client("localhost", 9200);
    }

    @Nonnull
    public static RestClientBuilder client(@Nonnull String location) {
        return RestClient.builder(HttpHost.create(location));
    }

    @Nonnull
    public static RestClientBuilder client(@Nonnull String hostname, int port) {
        return RestClient.builder(new HttpHost(hostname, port));
    }

    @Nonnull
    public static RestClientBuilder client(@Nonnull String username, @Nonnull String password, @Nonnull String hostname, int port) {
        return ElasticClients.client(username, password, hostname, port, "http");
    }

    @Nonnull
    public static RestClientBuilder client(@Nonnull String username, @Nonnull String password, @Nonnull String hostname, int port, @Nonnull String scheme) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, new UsernamePasswordCredentials(username, password));
        return RestClient.builder(new HttpHost(hostname, port, scheme)).setHttpClientConfigCallback(httpClientBuilder -> httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider));
    }
}

