/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.cdc;

import com.hazelcast.jet.annotation.EvolvingApi;
import com.hazelcast.jet.cdc.ParsingException;
import java.util.stream.Stream;
import javax.annotation.Nullable;

@EvolvingApi
public enum Operation {
    UNSPECIFIED(null),
    SYNC(Character.valueOf('r')),
    INSERT(Character.valueOf('c')),
    UPDATE(Character.valueOf('u')),
    DELETE(Character.valueOf('d'));

    private final Character id;

    private Operation(Character id) {
        this.id = id;
    }

    public String code() {
        return this.id == null ? null : String.valueOf(this.id);
    }

    public static Operation get(@Nullable String opcode) throws ParsingException {
        Operation op = Lookup.get(opcode);
        if (op == null) {
            throw new ParsingException("'" + opcode + "' is not a valid operation id");
        }
        return op;
    }

    private static class Lookup {
        private static final Operation[] ARRAY;

        private Lookup() {
        }

        static Operation get(String opcode) {
            if (opcode == null) {
                return UNSPECIFIED;
            }
            if (opcode.length() != 1) {
                return null;
            }
            char index = opcode.charAt(0);
            if (index >= ARRAY.length) {
                return null;
            }
            return ARRAY[index];
        }

        static {
            int maxId = Stream.of(Operation.values()).filter(op -> ((Operation)op).id != null).map(op -> ((Operation)op).id.charValue()).max(Integer::compareTo).orElse(0);
            ARRAY = new Operation[maxId + 1];
            Stream.of(Operation.values()).filter(op -> ((Operation)op).id != null).forEach(op -> {
                Lookup.ARRAY[((Operation)op).id.charValue()] = op;
            });
        }
    }
}

