/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.table;

import com.microsoft.azure.storage.core.Utility;
import com.microsoft.azure.storage.table.EdmType;
import com.microsoft.azure.storage.table.Encrypt;
import com.microsoft.azure.storage.table.EntityProperty;
import com.microsoft.azure.storage.table.Ignore;
import com.microsoft.azure.storage.table.StoreAs;
import com.microsoft.azure.storage.table.TableServiceEntity;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

final class PropertyPair {
    private Method getter = null;
    private Method setter = null;
    private String name = null;
    Class<?> type = null;
    String effectiveName = null;
    boolean isEncrypted = false;

    PropertyPair() {
    }

    protected static HashMap<String, PropertyPair> generatePropertyPairs(Class<?> clazzType) {
        if (!TableServiceEntity.isReflectedEntityCacheDisabled()) {
            HashMap<String, PropertyPair> props = new HashMap();
            props = TableServiceEntity.getReflectedEntityCache().get(clazzType);
            if (props == null) {
                props = PropertyPair.generatePropertyPairsHelper(clazzType);
                TableServiceEntity.getReflectedEntityCache().put(clazzType, props);
            }
            return props;
        }
        return PropertyPair.generatePropertyPairsHelper(clazzType);
    }

    private static HashMap<String, PropertyPair> generatePropertyPairsHelper(Class<?> clazzType) {
        Method[] methods = clazzType.getMethods();
        HashMap<String, PropertyPair> propMap = new HashMap<String, PropertyPair>();
        String propName = null;
        PropertyPair currProperty = null;
        for (Method m4 : methods) {
            if (m4.getName().length() < 4 || !m4.getName().startsWith("get") && !m4.getName().startsWith("set") || (propName = m4.getName().substring(3)).equals("PartitionKey") || propName.equals("RowKey") || propName.equals("Timestamp") || propName.equals("Etag") || propName.equals("LastModified")) continue;
            if (propMap.containsKey(propName)) {
                currProperty = propMap.get(propName);
            } else {
                currProperty = new PropertyPair();
                currProperty.name = propName;
                propMap.put(propName, currProperty);
            }
            if (m4.getName().startsWith("get") && m4.getParameterTypes().length == 0) {
                currProperty.type = m4.getReturnType();
                currProperty.getter = m4;
            } else if (m4.getName().startsWith("set") && m4.getParameterTypes().length == 1 && Void.TYPE.equals(m4.getReturnType())) {
                currProperty.setter = m4;
            }
            StoreAs storeAsInstance = m4.getAnnotation(StoreAs.class);
            if (storeAsInstance == null) continue;
            if (Utility.isNullOrEmpty(storeAsInstance.name())) {
                throw new IllegalArgumentException(String.format("StoreAs Annotation found for property %s with empty value.", currProperty.name));
            }
            if (currProperty.effectiveName != null && !currProperty.effectiveName.equals(currProperty.name) && !currProperty.effectiveName.equals(storeAsInstance.name())) {
                throw new IllegalArgumentException(String.format("StoreAs Annotation found for both getter and setter for property %s with unequal values.", currProperty.name));
            }
            if (currProperty.name.equals(storeAsInstance.name())) continue;
            currProperty.effectiveName = storeAsInstance.name();
        }
        ArrayList keysToRemove = new ArrayList();
        ArrayList keysToAlter = new ArrayList();
        for (Map.Entry e : propMap.entrySet()) {
            boolean bl = ((PropertyPair)e.getValue()).isEncrypted = ((PropertyPair)e.getValue()).setter != null && ((PropertyPair)e.getValue()).setter.isAnnotationPresent(Encrypt.class);
            if (!((PropertyPair)e.getValue()).shouldProcess()) {
                keysToRemove.add(e.getKey());
                continue;
            }
            if (!Utility.isNullOrEmpty(((PropertyPair)e.getValue()).effectiveName)) {
                keysToAlter.add(e.getKey());
                continue;
            }
            ((PropertyPair)e.getValue()).effectiveName = ((PropertyPair)e.getValue()).name;
        }
        for (String key : keysToRemove) {
            propMap.remove(key);
        }
        for (String key : keysToAlter) {
            PropertyPair p = propMap.get(key);
            propMap.remove(key);
            propMap.put(p.effectiveName, p);
        }
        return propMap;
    }

    protected void consumeEntityProperty(EntityProperty prop, Object instance) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> paramType = this.setter.getParameterTypes()[0];
        if (prop.getIsNull()) {
            if (!paramType.isPrimitive()) {
                this.setter.invoke(instance, new Object[]{null});
            }
        } else if (prop.getEdmType() == EdmType.STRING) {
            if (paramType.equals(String.class)) {
                this.setter.invoke(instance, prop.getValueAsString());
            }
        } else if (prop.getEdmType() == EdmType.BINARY) {
            if (paramType.equals(Byte[].class)) {
                this.setter.invoke(instance, new Object[]{prop.getValueAsByteObjectArray()});
            } else if (paramType.equals(byte[].class)) {
                this.setter.invoke(instance, new Object[]{prop.getValueAsByteArray()});
            }
        } else if (prop.getEdmType() == EdmType.BOOLEAN) {
            if (paramType.equals(Boolean.class)) {
                this.setter.invoke(instance, prop.getValueAsBooleanObject());
            } else if (paramType.equals(Boolean.TYPE)) {
                this.setter.invoke(instance, prop.getValueAsBoolean());
            }
        } else if (prop.getEdmType() == EdmType.DOUBLE) {
            if (paramType.equals(Double.class)) {
                this.setter.invoke(instance, prop.getValueAsDoubleObject());
            } else if (paramType.equals(Double.TYPE)) {
                this.setter.invoke(instance, prop.getValueAsDouble());
            }
        } else if (prop.getEdmType() == EdmType.GUID) {
            if (paramType.equals(UUID.class)) {
                this.setter.invoke(instance, prop.getValueAsUUID());
            }
        } else if (prop.getEdmType() == EdmType.INT32) {
            if (paramType.equals(Integer.class)) {
                this.setter.invoke(instance, prop.getValueAsIntegerObject());
            } else if (paramType.equals(Integer.TYPE)) {
                this.setter.invoke(instance, prop.getValueAsInteger());
            }
        } else if (prop.getEdmType() == EdmType.INT64) {
            if (paramType.equals(Long.class)) {
                this.setter.invoke(instance, prop.getValueAsLongObject());
            } else if (paramType.equals(Long.TYPE)) {
                this.setter.invoke(instance, prop.getValueAsLong());
            }
        } else if (prop.getEdmType() == EdmType.DATE_TIME) {
            if (paramType.equals(Date.class)) {
                this.setter.invoke(instance, prop.getValueAsDate());
            }
        } else {
            throw new IllegalArgumentException(String.format("Property %s with Edm Type %s cannot be de-serialized.", this.name, prop.getEdmType().toString()));
        }
    }

    protected EntityProperty generateEntityProperty(Object instance) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> getType = this.getter.getReturnType();
        Object val = this.getter.invoke(instance, (Object[])null);
        EntityProperty property = new EntityProperty(val, getType);
        property.setIsEncrypted(this.isEncrypted);
        return property;
    }

    protected boolean shouldProcess() {
        return !Utility.isNullOrEmpty(this.name) && this.getter != null && !this.getter.isAnnotationPresent(Ignore.class) && this.setter != null && !this.setter.isAnnotationPresent(Ignore.class) && this.getter.getReturnType().equals(this.setter.getParameterTypes()[0]);
    }
}

