/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.datalake.store.oauth2;

import com.microsoft.azure.datalake.store.oauth2.AccessTokenProvider;
import com.microsoft.azure.datalake.store.oauth2.AzureADToken;
import com.microsoft.azure.datalake.store.oauth2.DeviceCodeCallback;
import com.microsoft.azure.datalake.store.oauth2.DeviceCodeTokenProviderHelper;
import com.microsoft.azure.datalake.store.oauth2.RefreshTokenBasedTokenProvider;
import com.microsoft.azure.datalake.store.oauth2.RefreshTokenInfo;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceCodeTokenProvider
extends AccessTokenProvider {
    private static final Logger log = LoggerFactory.getLogger("com.microsoft.azure.datalake.store.oauth2.DeviceCodeTokenProvider");
    private RefreshTokenBasedTokenProvider tokenProviderInternal = null;
    private String refreshTokenString = null;

    public DeviceCodeTokenProvider(String appId) throws IOException {
        this(appId, null);
    }

    public DeviceCodeTokenProvider(String appId, DeviceCodeCallback callback) throws IOException {
        if (appId == null || appId.trim().length() == 0) {
            throw new IllegalArgumentException("appId is required");
        }
        if (callback == null) {
            callback = DeviceCodeCallback.getDefaultInstance();
        }
        RefreshTokenInfo token = DeviceCodeTokenProviderHelper.getRefreshToken(appId, callback);
        this.refreshTokenString = token.refreshToken;
        this.tokenProviderInternal = new RefreshTokenBasedTokenProvider(null, token);
    }

    @Override
    protected AzureADToken refreshToken() throws IOException {
        return this.tokenProviderInternal.refreshToken();
    }

    public String getRefreshToken() {
        return this.refreshTokenString;
    }
}

