/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.datalake.store;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.openssl.OpenSSLProvider;
import org.wildfly.openssl.SSL;

public class SSLSocketFactoryEx
extends SSLSocketFactory {
    private static SSLSocketFactoryEx instance = null;
    private static Object lock = new Object();
    private static final Logger log = LoggerFactory.getLogger("com.microsoft.azure.datalake.store.SSLSocketFactoryEx");
    private String userAgent;
    private SSLContext m_ctx;
    private String[] m_ciphers;
    private SSLChannelMode channelMode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SSLSocketFactoryEx getDefaultFactory(SSLChannelMode sslChannelMode) throws IOException {
        if (instance == null) {
            Object object = lock;
            synchronized (object) {
                if (instance == null) {
                    instance = new SSLSocketFactoryEx(sslChannelMode);
                    log.debug("SSLSocketFactoryEx created in " + sslChannelMode.name() + " mode");
                }
            }
        }
        return instance;
    }

    public SSLSocketFactoryEx(SSLChannelMode channelMode) throws IOException {
        this.channelMode = channelMode;
        try {
            this.initSSLSocketFactoryEx(null, null, null);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        catch (KeyManagementException e) {
            throw new IOException(e);
        }
        this.userAgent = this.m_ctx.getProvider().getName() + "-" + this.m_ctx.getProvider().getVersion();
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.m_ciphers;
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.m_ciphers;
    }

    @Override
    public Socket createSocket() throws IOException {
        SSLSocketFactory factory = this.m_ctx.getSocketFactory();
        SSLSocket ss = (SSLSocket)factory.createSocket();
        this.configureSocket(ss);
        return ss;
    }

    @Override
    public Socket createSocket(Socket s2, String host, int port, boolean autoClose) throws IOException {
        SSLSocketFactory factory = this.m_ctx.getSocketFactory();
        SSLSocket ss = (SSLSocket)factory.createSocket(s2, host, port, autoClose);
        this.configureSocket(ss);
        return ss;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        SSLSocketFactory factory = this.m_ctx.getSocketFactory();
        SSLSocket ss = (SSLSocket)factory.createSocket(address, port, localAddress, localPort);
        this.configureSocket(ss);
        return ss;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        SSLSocketFactory factory = this.m_ctx.getSocketFactory();
        SSLSocket ss = (SSLSocket)factory.createSocket(host, port, localHost, localPort);
        this.configureSocket(ss);
        return ss;
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        SSLSocketFactory factory = this.m_ctx.getSocketFactory();
        SSLSocket ss = (SSLSocket)factory.createSocket(host, port);
        this.configureSocket(ss);
        return ss;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        SSLSocketFactory factory = this.m_ctx.getSocketFactory();
        SSLSocket ss = (SSLSocket)factory.createSocket(host, port);
        this.configureSocket(ss);
        return ss;
    }

    private void configureSocket(SSLSocket ss) throws SocketException {
        ss.setEnabledCipherSuites(this.m_ciphers);
    }

    private void initSSLSocketFactoryEx(KeyManager[] km4, TrustManager[] tm, SecureRandom random) throws NoSuchAlgorithmException, KeyManagementException, IOException {
        switch (this.channelMode) {
            case Default: {
                try {
                    java.util.logging.Logger.getLogger(SSL.class.getName()).setLevel(Level.WARNING);
                    this.m_ctx = SSLContext.getInstance("openssl.TLS");
                    this.m_ctx.init(km4, tm, random);
                    this.channelMode = SSLChannelMode.OpenSSL;
                }
                catch (NoSuchAlgorithmException e) {
                    log.info("Failed to load OpenSSL library. Fallback to default JSE. ", e);
                    this.m_ctx = SSLContext.getDefault();
                    this.channelMode = SSLChannelMode.Default_JSE;
                }
                break;
            }
            case Default_JSE: {
                this.m_ctx = SSLContext.getDefault();
                break;
            }
            case OpenSSL: {
                this.m_ctx = SSLContext.getInstance("openssl.TLS");
                this.m_ctx.init(km4, tm, random);
            }
        }
        SSLSocketFactory factory = this.m_ctx.getSocketFactory();
        String[] defaultCiphers = factory.getSupportedCipherSuites();
        String version = System.getProperty("java.version");
        this.m_ciphers = this.channelMode == SSLChannelMode.Default_JSE && version.startsWith("1.8") ? this.alterCipherList(defaultCiphers) : defaultCiphers;
    }

    private String[] alterCipherList(String[] defaultCiphers) {
        ArrayList<String> preferredSuits = new ArrayList<String>();
        for (int i = 0; i < defaultCiphers.length; ++i) {
            if (defaultCiphers[i].contains("_GCM_")) {
                log.info("Removed Cipher - " + defaultCiphers[i]);
                continue;
            }
            preferredSuits.add(defaultCiphers[i]);
        }
        this.m_ciphers = preferredSuits.toArray(new String[0]);
        return this.m_ciphers;
    }

    static {
        OpenSSLProvider.register();
    }

    public static enum SSLChannelMode {
        OpenSSL,
        Default,
        Default_JSE;

    }
}

