/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.hadoop.impl;

import com.hazelcast.com.fasterxml.jackson.core.FormatSchema;
import com.hazelcast.com.fasterxml.jackson.databind.DeserializationFeature;
import com.hazelcast.com.fasterxml.jackson.databind.MappingIterator;
import com.hazelcast.com.fasterxml.jackson.databind.ObjectReader;
import com.hazelcast.com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.hazelcast.com.fasterxml.jackson.dataformat.csv.CsvParser;
import com.hazelcast.com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.hazelcast.jet.impl.util.ReflectionUtils;
import com.hazelcast.jet.impl.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.SplittableCompressionCodec;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.LineRecordReader;

public class CsvInputFormat
extends FileInputFormat<NullWritable, Object> {
    public static final String CSV_INPUT_FORMAT_BEAN_CLASS = "csv.bean.class";
    public static final String CSV_INPUT_FORMAT_FIELD_LIST_PREFIX = "csv.field.list.";

    @Override
    public RecordReader<NullWritable, Object> createRecordReader(InputSplit split, TaskAttemptContext context) {
        return new RecordReader<NullWritable, Object>(){
            private Class<?> formatClazz;
            private final LineRecordReader reader = new LineRecordReader();
            private ObjectReader objectReader;
            private Function<Object, Object> projection = Function.identity();

            @Override
            public void initialize(InputSplit split, TaskAttemptContext context) throws IOException {
                Configuration configuration;
                String className;
                this.reader.initialize(split, context);
                FileSplit fileSplit = (FileSplit)split;
                if (fileSplit.getStart() == 0L) {
                    this.reader.nextKeyValue();
                }
                this.formatClazz = (className = (configuration = context.getConfiguration()).get(CsvInputFormat.CSV_INPUT_FORMAT_BEAN_CLASS)) == null ? null : ReflectionUtils.loadClass((String)className);
                String[] header = this.readHeader(fileSplit, context);
                if (this.formatClazz == String[].class) {
                    String field;
                    this.objectReader = new CsvMapper().enable(CsvParser.Feature.WRAP_AS_ARRAY).readerFor(String[].class).with((FormatSchema)CsvSchema.emptySchema().withSkipFirstDataRow(false));
                    ArrayList<String> fieldNames = new ArrayList<String>();
                    int i = 0;
                    while ((field = configuration.get(CsvInputFormat.CSV_INPUT_FORMAT_FIELD_LIST_PREFIX + i)) != null) {
                        fieldNames.add(field);
                        ++i;
                    }
                    this.projection = Util.createFieldProjection((String[])header, fieldNames);
                } else {
                    CsvSchema.Builder builder = CsvSchema.builder();
                    for (String column : header) {
                        builder.addColumn(column);
                    }
                    this.objectReader = new CsvMapper().readerFor(this.formatClazz).withoutFeatures(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).with((FormatSchema)builder.build());
                }
            }

            /*
             * Exception decompiling
             */
            private String[] readHeader(FileSplit fileSplit, TaskAttemptContext context) throws IOException {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            private InputStream wrap(InputStream in, Configuration configuration, Path file) throws IOException {
                CompressionCodec codec = new CompressionCodecFactory(configuration).getCodec(file);
                return codec != null ? codec.createInputStream(in) : in;
            }

            @Override
            public boolean nextKeyValue() throws IOException {
                return this.reader.nextKeyValue();
            }

            @Override
            public NullWritable getCurrentKey() {
                return NullWritable.get();
            }

            @Override
            public Object getCurrentValue() throws IOException {
                String current = this.reader.getCurrentValue().toString();
                if (this.formatClazz == String[].class) {
                    try (MappingIterator iterator = this.objectReader.readValues(current);){
                        Object object = iterator.hasNext() ? this.projection.apply(iterator.next()) : null;
                        return object;
                    }
                }
                return current.isEmpty() ? null : this.projection.apply(this.objectReader.readValue(current));
            }

            @Override
            public float getProgress() throws IOException {
                return this.reader.getProgress();
            }

            @Override
            public void close() throws IOException {
                this.reader.close();
            }
        };
    }

    @Override
    protected boolean isSplitable(JobContext context, Path file) {
        CompressionCodec codec = new CompressionCodecFactory(context.getConfiguration()).getCodec(file);
        return null == codec || codec instanceof SplittableCompressionCodec;
    }
}

