/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.upgrades;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.metadata.MetadataUpdateSettingsService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.upgrades.SystemIndexMigrationTaskParams;
import org.elasticsearch.upgrades.SystemIndexMigrationTaskState;
import org.elasticsearch.upgrades.SystemIndexMigrator;

public class SystemIndexMigrationExecutor
extends PersistentTasksExecutor<SystemIndexMigrationTaskParams> {
    private final Client client;
    private final ClusterService clusterService;
    private final SystemIndices systemIndices;
    private final MetadataUpdateSettingsService metadataUpdateSettingsService;
    private final MetadataCreateIndexService metadataCreateIndexService;
    private final IndexScopedSettings indexScopedSettings;

    public SystemIndexMigrationExecutor(Client client, ClusterService clusterService, SystemIndices systemIndices, MetadataUpdateSettingsService metadataUpdateSettingsService, MetadataCreateIndexService metadataCreateIndexService, IndexScopedSettings indexScopedSettings) {
        super("upgrade-system-indices", "generic");
        this.client = client;
        this.clusterService = clusterService;
        this.systemIndices = systemIndices;
        this.metadataUpdateSettingsService = metadataUpdateSettingsService;
        this.metadataCreateIndexService = metadataCreateIndexService;
        this.indexScopedSettings = indexScopedSettings;
    }

    @Override
    protected void nodeOperation(AllocatedPersistentTask task, SystemIndexMigrationTaskParams params, PersistentTaskState state) {
        SystemIndexMigrator upgrader = (SystemIndexMigrator)task;
        SystemIndexMigrationTaskState upgraderState = (SystemIndexMigrationTaskState)state;
        upgrader.run(upgraderState);
    }

    @Override
    protected AllocatedPersistentTask createTask(long id, String type, String action, TaskId parentTaskId, PersistentTasksCustomMetadata.PersistentTask<SystemIndexMigrationTaskParams> taskInProgress, Map<String, String> headers) {
        return new SystemIndexMigrator(this.client, id, type, action, parentTaskId, taskInProgress.getParams(), headers, this.clusterService, this.systemIndices, this.metadataUpdateSettingsService, this.metadataCreateIndexService, this.indexScopedSettings);
    }

    @Override
    public PersistentTasksCustomMetadata.Assignment getAssignment(SystemIndexMigrationTaskParams params, Collection<DiscoveryNode> candidateNodes, ClusterState clusterState) {
        DiscoveryNode discoveryNode = clusterState.nodes().getMasterNode();
        if (discoveryNode == null) {
            return NO_NODE_FOUND;
        }
        return new PersistentTasksCustomMetadata.Assignment(discoveryNode.getId(), "");
    }

    public static List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return org.elasticsearch.core.List.of(new NamedWriteableRegistry.Entry(PersistentTaskState.class, "upgrade-system-indices", SystemIndexMigrationTaskState::new), new NamedWriteableRegistry.Entry(PersistentTaskParams.class, "upgrade-system-indices", SystemIndexMigrationTaskParams::new));
    }
}

