/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.runtime;

import java.util.Objects;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.common.util.BytesRefHash;
import org.elasticsearch.script.IpFieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.runtime.AbstractIpScriptFieldQuery;

public class IpScriptFieldTermsQuery
extends AbstractIpScriptFieldQuery {
    private final BytesRefHash terms;

    public IpScriptFieldTermsQuery(Script script, IpFieldScript.LeafFactory leafFactory, String fieldName, BytesRefHash terms) {
        super(script, leafFactory, fieldName);
        this.terms = terms;
    }

    @Override
    protected boolean matches(BytesRef[] values, int count) {
        for (int i = 0; i < count; ++i) {
            if (this.terms.find(values[i]) < 0L) continue;
            return true;
        }
        return false;
    }

    @Override
    public final String toString(String field) {
        StringBuilder b = new StringBuilder();
        if (!this.fieldName().contentEquals(field)) {
            b.append(this.fieldName()).append(":");
        }
        b.append("[");
        BytesRef spare = new BytesRef();
        long i = 0L;
        while (i < this.terms.size() && b.length() < 5000) {
            if (i != 0L) {
                b.append(", ");
            }
            b.append(InetAddresses.toAddrString(IpScriptFieldTermsQuery.decode(this.terms.get(i++, spare))));
        }
        if (i < this.terms.size()) {
            b.append("...");
        }
        return b.append("]").toString();
    }

    @Override
    public int hashCode() {
        long hash = 0L;
        BytesRef spare = new BytesRef();
        for (long i = 0L; i < this.terms.size(); ++i) {
            hash = 31L * hash + (long)this.terms.get(i, spare).hashCode();
        }
        return Objects.hash(super.hashCode(), hash);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        IpScriptFieldTermsQuery other = (IpScriptFieldTermsQuery)obj;
        if (this.terms.size() != other.terms.size()) {
            return false;
        }
        BytesRef mySpare = new BytesRef();
        BytesRef otherSpare = new BytesRef();
        for (long i = 0L; i < this.terms.size(); ++i) {
            this.terms.get(i, mySpare);
            other.terms.get(i, otherSpare);
            if (mySpare.bytesEquals(otherSpare)) continue;
            return false;
        }
        return true;
    }

    BytesRefHash terms() {
        return this.terms;
    }
}

