/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.builder;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.search.SearchContextId;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public final class PointInTimeBuilder
implements Writeable,
ToXContentObject {
    private static final ParseField ID_FIELD = new ParseField("id", new String[0]);
    private static final ParseField KEEP_ALIVE_FIELD = new ParseField("keep_alive", new String[0]);
    private static final ObjectParser<XContentParams, Void> PARSER = new ObjectParser(SearchSourceBuilder.POINT_IN_TIME.getPreferredName(), () -> new XContentParams());
    private final String encodedId;
    private transient SearchContextId searchContextId;
    private TimeValue keepAlive;

    public PointInTimeBuilder(String pitID) {
        this.encodedId = Objects.requireNonNull(pitID, "Point in time ID must be provided");
    }

    public PointInTimeBuilder(StreamInput in) throws IOException {
        this.encodedId = in.readString();
        this.keepAlive = in.readOptionalTimeValue();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.encodedId);
        out.writeOptionalTimeValue(this.keepAlive);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(SearchSourceBuilder.POINT_IN_TIME.getPreferredName());
        builder.field(ID_FIELD.getPreferredName(), this.encodedId);
        if (this.keepAlive != null) {
            builder.field(KEEP_ALIVE_FIELD.getPreferredName(), this.keepAlive);
        }
        builder.endObject();
        return builder;
    }

    public static PointInTimeBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParams params = PARSER.parse(parser, null);
        if (params.encodedId == null) {
            throw new IllegalArgumentException("point in time id is not provided");
        }
        return new PointInTimeBuilder(params.encodedId).setKeepAlive(params.keepAlive);
    }

    public String getEncodedId() {
        return this.encodedId;
    }

    public SearchContextId getSearchContextId(NamedWriteableRegistry namedWriteableRegistry) {
        if (this.searchContextId == null) {
            this.searchContextId = SearchContextId.decode(namedWriteableRegistry, this.encodedId);
        }
        return this.searchContextId;
    }

    public PointInTimeBuilder setKeepAlive(TimeValue keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    public PointInTimeBuilder setKeepAlive(String keepAlive) {
        return this.setKeepAlive(TimeValue.parseTimeValue(keepAlive, "keep_alive"));
    }

    @Nullable
    public TimeValue getKeepAlive() {
        return this.keepAlive;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PointInTimeBuilder that = (PointInTimeBuilder)o;
        return Objects.equals(this.encodedId, that.encodedId) && Objects.equals(this.keepAlive, that.keepAlive);
    }

    public int hashCode() {
        return Objects.hash(this.encodedId, this.keepAlive);
    }

    static {
        PARSER.declareString((params, id) -> ((XContentParams)params).encodedId = id, ID_FIELD);
        PARSER.declareField((params, keepAlive) -> ((XContentParams)params).keepAlive = keepAlive, (p, c) -> TimeValue.parseTimeValue(p.text(), KEEP_ALIVE_FIELD.getPreferredName()), KEEP_ALIVE_FIELD, ObjectParser.ValueType.STRING);
    }

    private static final class XContentParams {
        private String encodedId;
        private TimeValue keepAlive;

        private XContentParams() {
        }
    }
}

