/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.NotMasterException;
import org.elasticsearch.cluster.coordination.CoordinationMetadata;
import org.elasticsearch.cluster.coordination.CoordinationStateRejectedException;
import org.elasticsearch.cluster.coordination.Coordinator;
import org.elasticsearch.cluster.coordination.FailedToCommitClusterStateException;
import org.elasticsearch.cluster.coordination.Join;
import org.elasticsearch.cluster.coordination.JoinRequest;
import org.elasticsearch.cluster.coordination.JoinTaskExecutor;
import org.elasticsearch.cluster.coordination.StartJoinRequest;
import org.elasticsearch.cluster.coordination.ValidateJoinRequest;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RerouteService;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.discovery.zen.MembershipAction;
import org.elasticsearch.discovery.zen.ZenDiscovery;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.monitor.NodeHealthService;
import org.elasticsearch.monitor.StatusInfo;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public class JoinHelper {
    private static final Logger logger = LogManager.getLogger(JoinHelper.class);
    public static final String START_JOIN_ACTION_NAME = "internal:cluster/coordination/start_join";
    public static final String JOIN_ACTION_NAME = "internal:cluster/coordination/join";
    public static final String JOIN_VALIDATE_ACTION_NAME = "internal:cluster/coordination/join/validate";
    public static final String JOIN_PING_ACTION_NAME = "internal:cluster/coordination/join/ping";
    public static final Setting<TimeValue> JOIN_TIMEOUT_SETTING = Setting.timeSetting("cluster.join.timeout", TimeValue.timeValueMillis(60000L), TimeValue.timeValueMillis(1L), Setting.Property.NodeScope, Setting.Property.Deprecated);
    private final MasterService masterService;
    private final TransportService transportService;
    private volatile JoinTaskExecutor joinTaskExecutor;
    private final TimeValue joinTimeout;
    private final NodeHealthService nodeHealthService;
    private final Set<Tuple<DiscoveryNode, JoinRequest>> pendingOutgoingJoins = Collections.synchronizedSet(new HashSet());
    private final AtomicReference<FailedJoinAttempt> lastFailedJoinAttempt = new AtomicReference();
    private final Map<DiscoveryNode, Releasable> joinConnections = new HashMap<DiscoveryNode, Releasable>();
    private final Supplier<JoinTaskExecutor> joinTaskExecutorGenerator;

    JoinHelper(Settings settings, AllocationService allocationService, MasterService masterService, TransportService transportService, final LongSupplier currentTermSupplier, Supplier<ClusterState> currentStateSupplier, BiConsumer<JoinRequest, ActionListener<Void>> joinHandler, Function<StartJoinRequest, Join> joinLeaderInTerm, Collection<BiConsumer<DiscoveryNode, ClusterState>> joinValidators, RerouteService rerouteService, NodeHealthService nodeHealthService) {
        this.masterService = masterService;
        this.transportService = transportService;
        this.nodeHealthService = nodeHealthService;
        this.joinTimeout = JOIN_TIMEOUT_SETTING.get(settings);
        this.joinTaskExecutorGenerator = () -> new JoinTaskExecutor(settings, allocationService, logger, rerouteService){
            private final long term;
            {
                super(settings, allocationService, logger, rerouteService);
                this.term = currentTermSupplier.getAsLong();
            }

            @Override
            public ClusterStateTaskExecutor.ClusterTasksResult<JoinTaskExecutor.Task> execute(ClusterState currentState, List<JoinTaskExecutor.Task> joiningTasks) throws Exception {
                if (currentState.term() > this.term) {
                    logger.trace("encountered higher term {} than current {}, there is a newer master", (Object)currentState.term(), (Object)this.term);
                    throw new NotMasterException("Higher term encountered (current: " + currentState.term() + " > used: " + this.term + "), there is a newer master");
                }
                if (currentState.nodes().getMasterNodeId() == null && joiningTasks.stream().anyMatch(JoinTaskExecutor.Task::isBecomeMasterTask)) {
                    assert (currentState.term() < this.term) : "there should be at most one become master task per election (= by term)";
                    CoordinationMetadata coordinationMetadata = CoordinationMetadata.builder(currentState.coordinationMetadata()).term(this.term).build();
                    Metadata metadata = Metadata.builder(currentState.metadata()).coordinationMetadata(coordinationMetadata).build();
                    currentState = ClusterState.builder(currentState).metadata(metadata).build();
                } else if (currentState.nodes().isLocalNodeElectedMaster()) assert (currentState.term() == this.term) : "term should be stable for the same master";
                return super.execute(currentState, joiningTasks);
            }
        };
        transportService.registerRequestHandler(JOIN_ACTION_NAME, "generic", false, false, JoinRequest::new, (request, channel, task) -> joinHandler.accept((JoinRequest)request, new ChannelActionListener<TransportResponse.Empty, JoinRequest>(channel, JOIN_ACTION_NAME, (JoinRequest)request).map(ignored -> TransportResponse.Empty.INSTANCE)));
        transportService.registerRequestHandler("internal:discovery/zen/join", "generic", false, false, MembershipAction.JoinRequest::new, (request, channel, task) -> joinHandler.accept(new JoinRequest(request.getNode(), 0L, Optional.empty()), new ChannelActionListener<TransportResponse.Empty, MembershipAction.JoinRequest>(channel, "internal:discovery/zen/join", (MembershipAction.JoinRequest)request).map(ignored -> TransportResponse.Empty.INSTANCE)));
        transportService.registerRequestHandler(START_JOIN_ACTION_NAME, "generic", false, false, StartJoinRequest::new, (request, channel, task) -> {
            DiscoveryNode destination = request.getSourceNode();
            this.sendJoinRequest(destination, currentTermSupplier.getAsLong(), Optional.of((Join)joinLeaderInTerm.apply((StartJoinRequest)request)));
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        });
        transportService.registerRequestHandler(JOIN_PING_ACTION_NAME, "same", false, false, TransportRequest.Empty::new, (request, channel, task) -> channel.sendResponse(TransportResponse.Empty.INSTANCE));
        List<String> dataPaths = Environment.PATH_DATA_SETTING.get(settings);
        int maxLocalStorageNodes = NodeEnvironment.MAX_LOCAL_STORAGE_NODES_SETTING.get(settings);
        transportService.registerRequestHandler(JOIN_VALIDATE_ACTION_NAME, "generic", ValidateJoinRequest::new, (request, channel, task) -> {
            ClusterState localState = (ClusterState)currentStateSupplier.get();
            if (localState.metadata().clusterUUIDCommitted() && !localState.metadata().clusterUUID().equals(request.getState().metadata().clusterUUID())) {
                throw new CoordinationStateRejectedException("This node previously joined a cluster with UUID [" + localState.metadata().clusterUUID() + "] and is now trying to join a different cluster with UUID [" + request.getState().metadata().clusterUUID() + "]. " + JoinHelper.getClusterUuidMismatchExplanation(dataPaths, maxLocalStorageNodes), new Object[0]);
            }
            joinValidators.forEach(action -> action.accept(transportService.getLocalNode(), request.getState()));
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        });
        transportService.registerRequestHandler("internal:discovery/zen/join/validate", "generic", ValidateJoinRequest::new, (request, channel, task) -> {
            ClusterState localState = (ClusterState)currentStateSupplier.get();
            if (localState.metadata().clusterUUIDCommitted() && !localState.metadata().clusterUUID().equals(request.getState().metadata().clusterUUID())) {
                throw new CoordinationStateRejectedException("This node previously joined a cluster with UUID [" + localState.metadata().clusterUUID() + "] and is now trying to join a different cluster with UUID [" + request.getState().metadata().clusterUUID() + "] and a mix of versions. " + JoinHelper.getClusterUuidMismatchExplanation(dataPaths, maxLocalStorageNodes), new Object[0]);
            }
            joinValidators.forEach(action -> action.accept(transportService.getLocalNode(), request.getState()));
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        });
        transportService.registerRequestHandler("internal:discovery/zen/rejoin", "same", ZenDiscovery.RejoinClusterRequest::new, (request, channel, task) -> channel.sendResponse(TransportResponse.Empty.INSTANCE));
        transportService.registerRequestHandler("internal:discovery/zen/leave", "same", MembershipAction.LeaveRequest::new, (request, channel, task) -> channel.sendResponse(TransportResponse.Empty.INSTANCE));
    }

    static String getClusterUuidMismatchExplanation(List<String> dataPaths, int maxLocalStorageNodes) {
        return "This is forbidden and usually indicates an incorrect discovery or cluster bootstrapping configuration. Note that the cluster UUID persists across restarts and can only be changed by deleting the contents of the node's data " + (dataPaths.size() == 1 ? "path " : "paths ") + dataPaths + " which will also remove any data held by " + (maxLocalStorageNodes == 1 ? "this node." : "all nodes that use " + (dataPaths.size() == 1 ? "this data path." : "these data paths."));
    }

    boolean isJoinPending() {
        return !this.pendingOutgoingJoins.isEmpty();
    }

    public void sendJoinRequest(DiscoveryNode destination, long term, Optional<Join> optionalJoin) {
        this.sendJoinRequest(destination, term, optionalJoin, () -> {});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClusterStateApplied() {
        ArrayList<Releasable> releasables;
        Map<DiscoveryNode, Releasable> map = this.joinConnections;
        synchronized (map) {
            if (this.joinConnections.isEmpty()) {
                return;
            }
            releasables = new ArrayList<Releasable>(this.joinConnections.values());
            this.joinConnections.clear();
        }
        logger.debug("releasing [{}] connections on successful cluster state application", (Object)releasables.size());
        releasables.forEach(Releasables::close);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerConnection(DiscoveryNode destination, Releasable connectionReference) {
        Releasable previousConnection;
        Map<DiscoveryNode, Releasable> map = this.joinConnections;
        synchronized (map) {
            previousConnection = this.joinConnections.put(destination, connectionReference);
        }
        Releasables.close(previousConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterAndReleaseConnection(DiscoveryNode destination, Releasable connectionReference) {
        Map<DiscoveryNode, Releasable> map = this.joinConnections;
        synchronized (map) {
            this.joinConnections.remove(destination, connectionReference);
        }
        Releasables.close(connectionReference);
    }

    void logLastFailedJoinAttempt() {
        FailedJoinAttempt attempt = this.lastFailedJoinAttempt.get();
        if (attempt != null) {
            attempt.logWarnWithTimestamp();
            this.lastFailedJoinAttempt.compareAndSet(attempt, null);
        }
    }

    public void sendJoinRequest(final DiscoveryNode destination, long term, Optional<Join> optionalJoin, final Runnable onCompletion) {
        assert (destination.isMasterNode()) : "trying to join master-ineligible " + destination;
        StatusInfo statusInfo = this.nodeHealthService.getHealth();
        if (statusInfo.getStatus() == StatusInfo.Status.UNHEALTHY) {
            logger.debug("dropping join request to [{}]: [{}]", (Object)destination, (Object)statusInfo.getInfo());
            return;
        }
        final JoinRequest joinRequest = new JoinRequest(this.transportService.getLocalNode(), term, optionalJoin);
        final Tuple<DiscoveryNode, JoinRequest> dedupKey = Tuple.tuple(destination, joinRequest);
        if (this.pendingOutgoingJoins.add(dedupKey)) {
            logger.debug("attempting to join {} with {}", (Object)destination, (Object)joinRequest);
            this.transportService.connectToNode(destination, new ActionListener<Releasable>(){

                @Override
                public void onResponse(final Releasable connectionReference) {
                    logger.trace("acquired connection for joining join {} with {}", (Object)destination, (Object)joinRequest);
                    JoinHelper.this.registerConnection(destination, connectionReference);
                    if (Coordinator.isZen1Node(destination)) {
                        JoinHelper.this.transportService.sendRequest(destination, "internal:discovery/zen/join", (TransportRequest)new MembershipAction.JoinRequest(JoinHelper.this.transportService.getLocalNode()), TransportRequestOptions.timeout(JoinHelper.this.joinTimeout), new TransportResponseHandler.Empty(){

                            @Override
                            public void handleResponse(TransportResponse.Empty response) {
                                JoinHelper.this.pendingOutgoingJoins.remove(dedupKey);
                                logger.debug("successfully joined {} with {}", (Object)destination, (Object)joinRequest);
                                JoinHelper.this.lastFailedJoinAttempt.set(null);
                                onCompletion.run();
                            }

                            @Override
                            public void handleException(TransportException exp) {
                                JoinHelper.this.pendingOutgoingJoins.remove(dedupKey);
                                logger.info(() -> new ParameterizedMessage("failed to join {} with {}", (Object)destination, (Object)joinRequest), (Throwable)exp);
                                FailedJoinAttempt attempt = new FailedJoinAttempt(destination, joinRequest, exp);
                                attempt.logNow();
                                JoinHelper.this.lastFailedJoinAttempt.set(attempt);
                                JoinHelper.this.unregisterAndReleaseConnection(destination, connectionReference);
                                onCompletion.run();
                            }
                        });
                        return;
                    }
                    JoinHelper.this.transportService.sendRequest(destination, JoinHelper.JOIN_ACTION_NAME, (TransportRequest)joinRequest, TransportRequestOptions.of(null, TransportRequestOptions.Type.PING), new TransportResponseHandler.Empty(){

                        @Override
                        public void handleResponse(TransportResponse.Empty response) {
                            JoinHelper.this.pendingOutgoingJoins.remove(dedupKey);
                            logger.debug("successfully joined {} with {}", (Object)destination, (Object)joinRequest);
                            JoinHelper.this.lastFailedJoinAttempt.set(null);
                        }

                        @Override
                        public void handleException(TransportException exp) {
                            JoinHelper.this.pendingOutgoingJoins.remove(dedupKey);
                            FailedJoinAttempt attempt = new FailedJoinAttempt(destination, joinRequest, exp);
                            attempt.logNow();
                            JoinHelper.this.lastFailedJoinAttempt.set(attempt);
                            JoinHelper.this.unregisterAndReleaseConnection(destination, connectionReference);
                        }
                    });
                }

                @Override
                public void onFailure(Exception e) {
                    JoinHelper.this.pendingOutgoingJoins.remove(dedupKey);
                    FailedJoinAttempt attempt = new FailedJoinAttempt(destination, joinRequest, new ConnectTransportException(destination, "failed to acquire connection", e));
                    attempt.logNow();
                    JoinHelper.this.lastFailedJoinAttempt.set(attempt);
                    onCompletion.run();
                }
            });
        } else {
            logger.debug("already attempting to join {} with request {}, not sending request", (Object)destination, (Object)joinRequest);
        }
    }

    public void sendStartJoinRequest(final StartJoinRequest startJoinRequest, final DiscoveryNode destination) {
        assert (startJoinRequest.getSourceNode().isMasterNode()) : "sending start-join request for master-ineligible " + startJoinRequest.getSourceNode();
        this.transportService.sendRequest(destination, START_JOIN_ACTION_NAME, startJoinRequest, new TransportResponseHandler.Empty(){

            @Override
            public void handleResponse(TransportResponse.Empty response) {
                logger.debug("successful response to {} from {}", (Object)startJoinRequest, (Object)destination);
            }

            @Override
            public void handleException(TransportException exp) {
                logger.debug((Message)new ParameterizedMessage("failure in response to {} from {}", (Object)startJoinRequest, (Object)destination), (Throwable)exp);
            }
        });
    }

    static class FailedJoinAttempt {
        private final DiscoveryNode destination;
        private final JoinRequest joinRequest;
        private final TransportException exception;
        private final long timestamp;

        FailedJoinAttempt(DiscoveryNode destination, JoinRequest joinRequest, TransportException exception) {
            this.destination = destination;
            this.joinRequest = joinRequest;
            this.exception = exception;
            this.timestamp = System.nanoTime();
        }

        void logNow() {
            logger.log(FailedJoinAttempt.getLogLevel(this.exception), () -> new ParameterizedMessage("failed to join {} with {}", (Object)this.destination, (Object)this.joinRequest), (Throwable)this.exception);
        }

        static Level getLogLevel(TransportException e) {
            Throwable cause = e.unwrapCause();
            if (cause instanceof CoordinationStateRejectedException || cause instanceof FailedToCommitClusterStateException || cause instanceof NotMasterException) {
                return Level.DEBUG;
            }
            return Level.INFO;
        }

        void logWarnWithTimestamp() {
            logger.warn(() -> new ParameterizedMessage("last failed join attempt was {} ago, failed to join {} with {}", new Object[]{TimeValue.timeValueMillis(TimeValue.nsecToMSec(System.nanoTime() - this.timestamp)), this.destination, this.joinRequest}), (Throwable)this.exception);
        }
    }

    class CandidateJoinAccumulator
    implements JoinAccumulator {
        private final Map<DiscoveryNode, ActionListener<Void>> joinRequestAccumulator = new HashMap<DiscoveryNode, ActionListener<Void>>();
        boolean closed;

        CandidateJoinAccumulator() {
        }

        @Override
        public void handleJoinRequest(DiscoveryNode sender, ActionListener<Void> joinListener) {
            assert (!this.closed) : "CandidateJoinAccumulator closed";
            ActionListener<Void> prev = this.joinRequestAccumulator.put(sender, joinListener);
            if (prev != null) {
                prev.onFailure(new CoordinationStateRejectedException("received a newer join from " + sender, new Object[0]));
            }
        }

        @Override
        public void close(Coordinator.Mode newMode) {
            assert (!this.closed) : "CandidateJoinAccumulator closed";
            this.closed = true;
            if (newMode == Coordinator.Mode.LEADER) {
                LinkedHashMap<JoinTaskExecutor.Task, ClusterStateTaskListener> pendingAsTasks = new LinkedHashMap<JoinTaskExecutor.Task, ClusterStateTaskListener>();
                this.joinRequestAccumulator.forEach((key, value) -> {
                    JoinTaskExecutor.Task task = new JoinTaskExecutor.Task((DiscoveryNode)key, "elect leader");
                    pendingAsTasks.put(task, new JoinTaskListener(task, (ActionListener<Void>)value));
                });
                String stateUpdateSource = "elected-as-master ([" + pendingAsTasks.size() + "] nodes joined)";
                pendingAsTasks.put(JoinTaskExecutor.newBecomeMasterTask(), (source, e) -> {});
                pendingAsTasks.put(JoinTaskExecutor.newFinishElectionTask(), (source, e) -> {});
                JoinHelper.this.joinTaskExecutor = (JoinTaskExecutor)JoinHelper.this.joinTaskExecutorGenerator.get();
                JoinHelper.this.masterService.submitStateUpdateTasks(stateUpdateSource, pendingAsTasks, ClusterStateTaskConfig.build(Priority.URGENT), JoinHelper.this.joinTaskExecutor);
            } else {
                assert (newMode == Coordinator.Mode.FOLLOWER) : newMode;
                JoinHelper.this.joinTaskExecutor = null;
                this.joinRequestAccumulator.values().forEach(joinCallback -> joinCallback.onFailure(new CoordinationStateRejectedException("became follower", new Object[0])));
            }
        }

        public String toString() {
            return "CandidateJoinAccumulator{" + this.joinRequestAccumulator.keySet() + ", closed=" + this.closed + '}';
        }
    }

    static class FollowerJoinAccumulator
    implements JoinAccumulator {
        FollowerJoinAccumulator() {
        }

        @Override
        public void handleJoinRequest(DiscoveryNode sender, ActionListener<Void> joinListener) {
            joinListener.onFailure(new CoordinationStateRejectedException("join target is a follower", new Object[0]));
        }

        public String toString() {
            return "FollowerJoinAccumulator";
        }
    }

    static class InitialJoinAccumulator
    implements JoinAccumulator {
        InitialJoinAccumulator() {
        }

        @Override
        public void handleJoinRequest(DiscoveryNode sender, ActionListener<Void> joinListener) {
            assert (false) : "unexpected join from " + sender + " during initialisation";
            joinListener.onFailure(new CoordinationStateRejectedException("join target is not initialised yet", new Object[0]));
        }

        public String toString() {
            return "InitialJoinAccumulator";
        }
    }

    class LeaderJoinAccumulator
    implements JoinAccumulator {
        LeaderJoinAccumulator() {
        }

        @Override
        public void handleJoinRequest(DiscoveryNode sender, ActionListener<Void> joinListener) {
            JoinTaskExecutor.Task task = new JoinTaskExecutor.Task(sender, "join existing leader");
            assert (JoinHelper.this.joinTaskExecutor != null);
            JoinHelper.this.masterService.submitStateUpdateTask("node-join", task, ClusterStateTaskConfig.build(Priority.URGENT), JoinHelper.this.joinTaskExecutor, new JoinTaskListener(task, joinListener));
        }

        public String toString() {
            return "LeaderJoinAccumulator";
        }
    }

    static interface JoinAccumulator {
        public void handleJoinRequest(DiscoveryNode var1, ActionListener<Void> var2);

        default public void close(Coordinator.Mode newMode) {
        }
    }

    static class JoinTaskListener
    implements ClusterStateTaskListener {
        private final JoinTaskExecutor.Task task;
        private final ActionListener<Void> joinListener;

        JoinTaskListener(JoinTaskExecutor.Task task, ActionListener<Void> joinListener) {
            this.task = task;
            this.joinListener = joinListener;
        }

        @Override
        public void onFailure(String source, Exception e) {
            this.joinListener.onFailure(e);
        }

        @Override
        public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
            this.joinListener.onResponse(null);
        }

        public String toString() {
            return "JoinTaskListener{task=" + this.task + "}";
        }
    }
}

