/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.transform;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.client.ValidationException;
import org.elasticsearch.client.transform.transforms.TransformConfig;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class PreviewTransformRequest
implements ToXContentObject,
Validatable {
    private final String transformId;
    private final TransformConfig config;

    public PreviewTransformRequest(String transformId) {
        this.transformId = Objects.requireNonNull(transformId);
        this.config = null;
    }

    public PreviewTransformRequest(TransformConfig config) {
        this.transformId = null;
        this.config = Objects.requireNonNull(config);
    }

    public String getTransformId() {
        return this.transformId;
    }

    public TransformConfig getConfig() {
        return this.config;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.config != null) {
            return this.config.toXContent(builder, params);
        }
        return builder.startObject().field(TransformConfig.ID.getPreferredName(), this.transformId).endObject();
    }

    @Override
    public Optional<ValidationException> validate() {
        ValidationException validationException = new ValidationException();
        if (this.config != null && this.config.getSource() == null) {
            validationException.addValidationError("transform source cannot be null");
        }
        if (validationException.validationErrors().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(validationException);
    }

    public int hashCode() {
        return Objects.hash(this.transformId, this.config);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PreviewTransformRequest other = (PreviewTransformRequest)obj;
        return Objects.equals(this.transformId, other.transformId) && Objects.equals(this.config, other.config);
    }
}

