/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.client.security.AuthenticateResponse;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

public final class CreateTokenResponse {
    private final String accessToken;
    private final String type;
    private final TimeValue expiresIn;
    private final String scope;
    private final String refreshToken;
    private final String kerberosAuthenticationResponseToken;
    private final AuthenticateResponse authentication;
    private static final ConstructingObjectParser<CreateTokenResponse, Void> PARSER = new ConstructingObjectParser("create_token_response", true, args -> new CreateTokenResponse((String)args[0], (String)args[1], TimeValue.timeValueSeconds((Long)args[2]), (String)args[3], (String)args[4], (String)args[5], (AuthenticateResponse)args[6]));

    public CreateTokenResponse(String accessToken, String type, TimeValue expiresIn, String scope, String refreshToken, String kerberosAuthenticationResponseToken, AuthenticateResponse authentication) {
        this.accessToken = accessToken;
        this.type = type;
        this.expiresIn = expiresIn;
        this.scope = scope;
        this.refreshToken = refreshToken;
        this.kerberosAuthenticationResponseToken = kerberosAuthenticationResponseToken;
        this.authentication = authentication;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getType() {
        return this.type;
    }

    public TimeValue getExpiresIn() {
        return this.expiresIn;
    }

    public String getScope() {
        return this.scope;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getKerberosAuthenticationResponseToken() {
        return this.kerberosAuthenticationResponseToken;
    }

    public AuthenticateResponse getAuthentication() {
        return this.authentication;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateTokenResponse that = (CreateTokenResponse)o;
        return Objects.equals(this.accessToken, that.accessToken) && Objects.equals(this.type, that.type) && Objects.equals(this.expiresIn, that.expiresIn) && Objects.equals(this.scope, that.scope) && Objects.equals(this.refreshToken, that.refreshToken) && Objects.equals(this.kerberosAuthenticationResponseToken, that.kerberosAuthenticationResponseToken) && Objects.equals(this.authentication, that.authentication);
    }

    public int hashCode() {
        return Objects.hash(this.accessToken, this.type, this.expiresIn, this.scope, this.refreshToken, this.kerberosAuthenticationResponseToken, this.authentication);
    }

    public static CreateTokenResponse fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("access_token", new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("type", new String[0]));
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField("expires_in", new String[0]));
        PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), new ParseField("scope", new String[0]));
        PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), new ParseField("refresh_token", new String[0]));
        PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), new ParseField("kerberos_authentication_response_token", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> AuthenticateResponse.fromXContent(p), new ParseField("authentication", new String[0]));
    }
}

