/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.dataframe.evaluation.classification;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.client.ml.dataframe.evaluation.Evaluation;
import org.elasticsearch.client.ml.dataframe.evaluation.EvaluationMetric;
import org.elasticsearch.client.ml.dataframe.evaluation.MlEvaluationNamedXContentProvider;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class Classification
implements Evaluation {
    public static final String NAME = "classification";
    private static final ParseField ACTUAL_FIELD = new ParseField("actual_field", new String[0]);
    private static final ParseField PREDICTED_FIELD = new ParseField("predicted_field", new String[0]);
    private static final ParseField TOP_CLASSES_FIELD = new ParseField("top_classes_field", new String[0]);
    private static final ParseField METRICS = new ParseField("metrics", new String[0]);
    public static final ConstructingObjectParser<Classification, Void> PARSER = new ConstructingObjectParser("classification", true, a -> new Classification((String)a[0], (String)a[1], (String)a[2], (List)a[3]));
    private final String actualField;
    private final String predictedField;
    private final String topClassesField;
    private final List<EvaluationMetric> metrics;

    public static Classification fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public Classification(String actualField, String predictedField, String topClassesField) {
        this(actualField, predictedField, topClassesField, (List<EvaluationMetric>)null);
    }

    public Classification(String actualField, String predictedField, String topClassesField, EvaluationMetric ... metrics) {
        this(actualField, predictedField, topClassesField, Arrays.asList(metrics));
    }

    public Classification(String actualField, @Nullable String predictedField, @Nullable String topClassesField, @Nullable List<EvaluationMetric> metrics) {
        this.actualField = Objects.requireNonNull(actualField);
        this.predictedField = predictedField;
        this.topClassesField = topClassesField;
        if (metrics != null) {
            metrics.sort(Comparator.comparing(EvaluationMetric::getName));
        }
        this.metrics = metrics;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ACTUAL_FIELD.getPreferredName(), this.actualField);
        if (this.predictedField != null) {
            builder.field(PREDICTED_FIELD.getPreferredName(), this.predictedField);
        }
        if (this.topClassesField != null) {
            builder.field(TOP_CLASSES_FIELD.getPreferredName(), this.topClassesField);
        }
        if (this.metrics != null) {
            builder.startObject(METRICS.getPreferredName());
            for (EvaluationMetric metric : this.metrics) {
                builder.field(metric.getName(), metric);
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Classification that = (Classification)o;
        return Objects.equals(that.actualField, this.actualField) && Objects.equals(that.predictedField, this.predictedField) && Objects.equals(that.topClassesField, this.topClassesField) && Objects.equals(that.metrics, this.metrics);
    }

    public int hashCode() {
        return Objects.hash(this.actualField, this.predictedField, this.topClassesField, this.metrics);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), ACTUAL_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), PREDICTED_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), TOP_CLASSES_FIELD);
        PARSER.declareNamedObjects(ConstructingObjectParser.optionalConstructorArg(), (p, c, n) -> p.namedObject(EvaluationMetric.class, MlEvaluationNamedXContentProvider.registeredMetricName(NAME, n), c), METRICS);
    }
}

