/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.search.grouping.CollapseTopFieldDocs;
import org.apache.lucene.search.grouping.CollapsingDocValuesSource;
import org.apache.lucene.search.grouping.CollectedSearchGroup;
import org.apache.lucene.search.grouping.FirstPassGroupingCollector;
import org.apache.lucene.search.grouping.GroupSelector;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.MappedFieldType;

public final class CollapsingTopDocsCollector<T>
extends FirstPassGroupingCollector<T> {
    protected final String collapseField;
    protected final Sort sort;
    private int totalHitCount;
    private final FieldDoc after;
    private final FieldComparator<?> comparator;
    private final int reversed;
    private LeafFieldComparator leafComparator;

    CollapsingTopDocsCollector(GroupSelector<T> groupSelector, String collapseField, Sort sort, int topN, FieldDoc after) {
        super(groupSelector, sort, topN);
        this.collapseField = collapseField;
        this.sort = sort;
        this.after = after;
        assert (after == null || sort.getSort().length == 1 && after.doc == Integer.MAX_VALUE);
        SortField sortField = sort.getSort()[0];
        this.comparator = sortField.getComparator(0, 0);
        if (after != null) {
            this.comparator.setTopValue(after.fields[0]);
        }
        this.reversed = sortField.getReverse() ? -1 : 1;
    }

    public CollapseTopFieldDocs getTopDocs() throws IOException {
        Collection groups = super.getTopGroups(0);
        if (groups == null) {
            TotalHits totalHits = new TotalHits(this.totalHitCount, TotalHits.Relation.EQUAL_TO);
            return new CollapseTopFieldDocs(this.collapseField, totalHits, new ScoreDoc[0], this.sort.getSort(), new Object[0]);
        }
        ScoreDoc[] docs = new FieldDoc[groups.size()];
        Object[] collapseValues = new Object[groups.size()];
        int scorePos = -1;
        for (int index = 0; index < this.sort.getSort().length; ++index) {
            SortField sortField = this.sort.getSort()[index];
            if (sortField.getType() != SortField.Type.SCORE) continue;
            scorePos = index;
            break;
        }
        int pos = 0;
        Iterator it = this.orderedGroups.iterator();
        for (SearchGroup group : groups) {
            assert (it.hasNext());
            CollectedSearchGroup col = (CollectedSearchGroup)it.next();
            float score = Float.NaN;
            if (scorePos != -1) {
                score = ((Float)group.sortValues[scorePos]).floatValue();
            }
            docs[pos] = new FieldDoc(col.topDoc, score, group.sortValues);
            collapseValues[pos] = group.groupValue;
            ++pos;
        }
        TotalHits totalHits = new TotalHits(this.totalHitCount, TotalHits.Relation.EQUAL_TO);
        return new CollapseTopFieldDocs(this.collapseField, totalHits, docs, this.sort.getSort(), collapseValues);
    }

    @Override
    public ScoreMode scoreMode() {
        if (super.scoreMode().needsScores()) {
            return ScoreMode.COMPLETE;
        }
        return ScoreMode.COMPLETE_NO_SCORES;
    }

    @Override
    protected void doSetNextReader(LeafReaderContext readerContext) throws IOException {
        this.leafComparator = this.comparator.getLeafComparator(readerContext);
        super.doSetNextReader(readerContext);
    }

    @Override
    public void collect(int doc) throws IOException {
        int cmp;
        ++this.totalHitCount;
        if (this.after != null && (cmp = this.reversed * this.leafComparator.compareTop(doc)) >= 0) {
            return;
        }
        super.collect(doc);
    }

    public static CollapsingTopDocsCollector<?> createNumeric(String collapseField, MappedFieldType collapseFieldType, Sort sort, int topN, @Nullable FieldDoc after) {
        return new CollapsingTopDocsCollector<Long>(new CollapsingDocValuesSource.Numeric(collapseFieldType), collapseField, sort, topN, after);
    }

    public static CollapsingTopDocsCollector<?> createKeyword(String collapseField, MappedFieldType collapseFieldType, Sort sort, int topN, @Nullable FieldDoc after) {
        return new CollapsingTopDocsCollector<BytesRef>(new CollapsingDocValuesSource.Keyword(collapseFieldType), collapseField, sort, topN, after);
    }
}

