/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.elastic;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.elastic.impl.ElasticSourceConfiguration;
import com.hazelcast.jet.elastic.impl.ElasticSourcePMetaSupplier;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.pipeline.BatchSource;
import com.hazelcast.jet.pipeline.Sources;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.search.SearchHit;

public final class ElasticSourceBuilder<T> {
    private static final String DEFAULT_NAME = "elasticSource";
    private static final int DEFAULT_RETRIES = 5;
    private SupplierEx<RestClientBuilder> clientFn;
    private SupplierEx<SearchRequest> searchRequestFn;
    private FunctionEx<? super ActionRequest, RequestOptions> optionsFn = (FunctionEx & Serializable)request -> RequestOptions.DEFAULT;
    private FunctionEx<? super SearchHit, T> mapToItemFn;
    private boolean slicing;
    private boolean coLocatedReading;
    private String scrollKeepAlive = "1m";
    private int retries = 5;

    @Nonnull
    public BatchSource<T> build() {
        Objects.requireNonNull(this.clientFn, "clientFn must be set");
        Objects.requireNonNull(this.searchRequestFn, "searchRequestFn must be set");
        Objects.requireNonNull(this.mapToItemFn, "mapToItemFn must be set");
        ElasticSourceConfiguration<T> configuration = new ElasticSourceConfiguration<T>(this.restHighLevelClientFn(this.clientFn), this.searchRequestFn, this.optionsFn, this.mapToItemFn, this.slicing, this.coLocatedReading, this.scrollKeepAlive, this.retries);
        ElasticSourcePMetaSupplier<T> metaSupplier = new ElasticSourcePMetaSupplier<T>(configuration);
        return Sources.batchFromProcessor((String)DEFAULT_NAME, metaSupplier);
    }

    private SupplierEx<RestHighLevelClient> restHighLevelClientFn(SupplierEx<RestClientBuilder> clientFn) {
        return (SupplierEx & Serializable)() -> new RestHighLevelClient((RestClientBuilder)clientFn.get());
    }

    @Nonnull
    public ElasticSourceBuilder<T> clientFn(@Nonnull SupplierEx<RestClientBuilder> clientFn) {
        this.clientFn = (SupplierEx)Util.checkNonNullAndSerializable(clientFn, (String)"clientFn");
        return this;
    }

    @Nonnull
    public ElasticSourceBuilder<T> searchRequestFn(@Nonnull SupplierEx<SearchRequest> searchRequestFn) {
        this.searchRequestFn = (SupplierEx)Util.checkSerializable(searchRequestFn, (String)"searchRequestFn");
        return this;
    }

    @Nonnull
    public <T_NEW> ElasticSourceBuilder<T_NEW> mapToItemFn(@Nonnull FunctionEx<? super SearchHit, T_NEW> mapToItemFn) {
        ElasticSourceBuilder newThis = this;
        newThis.mapToItemFn = (FunctionEx)Util.checkSerializable(mapToItemFn, (String)"mapToItemFn");
        return newThis;
    }

    @Nonnull
    public ElasticSourceBuilder<T> optionsFn(@Nonnull FunctionEx<? super ActionRequest, RequestOptions> optionsFn) {
        this.optionsFn = (FunctionEx)Util.checkSerializable(optionsFn, (String)"optionsFn");
        return this;
    }

    @Nonnull
    public ElasticSourceBuilder<T> enableSlicing() {
        this.slicing = true;
        return this;
    }

    @Nonnull
    public ElasticSourceBuilder<T> enableCoLocatedReading() {
        this.coLocatedReading = true;
        return this;
    }

    @Nonnull
    public ElasticSourceBuilder<T> scrollKeepAlive(@Nonnull String scrollKeepAlive) {
        this.scrollKeepAlive = Objects.requireNonNull(scrollKeepAlive, scrollKeepAlive);
        return this;
    }

    @Nonnull
    public ElasticSourceBuilder<T> retries(int retries) {
        if (retries < 0) {
            throw new IllegalArgumentException("retries must be positive");
        }
        this.retries = retries;
        return this;
    }
}

