/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.elastic;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.elastic.ElasticClients;
import com.hazelcast.jet.elastic.ElasticSinkBuilder;
import com.hazelcast.jet.pipeline.Sink;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.client.RestClientBuilder;

public final class ElasticSinks {
    private ElasticSinks() {
    }

    @Nonnull
    public static <T> Sink<T> elastic(@Nonnull FunctionEx<? super T, ? extends DocWriteRequest<?>> mapToRequestFn) {
        return ElasticSinks.elastic((SupplierEx<RestClientBuilder>)((SupplierEx & Serializable)ElasticClients::client), mapToRequestFn);
    }

    @Nonnull
    public static <T> Sink<T> elastic(@Nonnull SupplierEx<RestClientBuilder> clientFn, @Nonnull FunctionEx<? super T, ? extends DocWriteRequest<?>> mapToRequestFn) {
        ElasticSinkBuilder<T> builder = new ElasticSinkBuilder().clientFn(clientFn).mapToRequestFn(mapToRequestFn);
        return builder.build();
    }

    @Nonnull
    public static ElasticSinkBuilder<Void> builder() {
        return new ElasticSinkBuilder<Void>();
    }
}

