/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.kafka.impl;

import com.hazelcast.internal.util.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.internals.TransactionManager;

final class ResumeTransactionUtil {
    private static final String TRANSACTION_MANAGER_FIELD_NAME = "transactionManager";
    private static final String TRANSACTION_MANAGER_STATE_ENUM = "org.apache.kafka.clients.producer.internals.TransactionManager$State";
    private static final String PRODUCER_ID_AND_EPOCH_FIELD_NAME = "producerIdAndEpoch";

    private ResumeTransactionUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void resumeTransaction(KafkaProducer producer, long producerId, short epoch) {
        Object transactionManager;
        Preconditions.checkState((producerId >= 0L && epoch >= 0 ? 1 : 0) != 0, (String)("Incorrect values for producerId " + producerId + " and epoch " + epoch));
        Object object = transactionManager = ResumeTransactionUtil.getTransactionManager(producer);
        synchronized (object) {
            Object topicPartitionBookkeeper = ResumeTransactionUtil.getField(transactionManager, "txnPartitionMap");
            ResumeTransactionUtil.transitionTransactionManagerStateTo(transactionManager, "INITIALIZING");
            ResumeTransactionUtil.invoke(topicPartitionBookkeeper, "reset", new Object[0]);
            ResumeTransactionUtil.setField(transactionManager, PRODUCER_ID_AND_EPOCH_FIELD_NAME, ResumeTransactionUtil.createProducerIdAndEpoch(producerId, epoch));
            ResumeTransactionUtil.transitionTransactionManagerStateTo(transactionManager, "READY");
            ResumeTransactionUtil.transitionTransactionManagerStateTo(transactionManager, "IN_TRANSACTION");
            ResumeTransactionUtil.setField(transactionManager, "transactionStarted", true);
        }
    }

    static long getProducerId(KafkaProducer kafkaProducer) {
        Object transactionManager = ResumeTransactionUtil.getValue(kafkaProducer, TRANSACTION_MANAGER_FIELD_NAME);
        Object producerIdAndEpoch = ResumeTransactionUtil.getValue(transactionManager, PRODUCER_ID_AND_EPOCH_FIELD_NAME);
        return (Long)ResumeTransactionUtil.getValue(producerIdAndEpoch, "producerId");
    }

    static short getEpoch(KafkaProducer kafkaProducer) {
        Object transactionManager = ResumeTransactionUtil.getValue(kafkaProducer, TRANSACTION_MANAGER_FIELD_NAME);
        Object producerIdAndEpoch = ResumeTransactionUtil.getValue(transactionManager, PRODUCER_ID_AND_EPOCH_FIELD_NAME);
        return (Short)ResumeTransactionUtil.getValue(producerIdAndEpoch, "epoch");
    }

    private static Object invoke(Object object, String methodName, Object ... args) {
        Class[] argTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            argTypes[i] = args[i].getClass();
        }
        return ResumeTransactionUtil.invoke(object, methodName, argTypes, args);
    }

    private static Object invoke(Object object, String methodName, Class<?>[] argTypes, Object[] args) {
        try {
            Method method = object.getClass().getDeclaredMethod(methodName, argTypes);
            method.setAccessible(true);
            return method.invoke(object, args);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Incompatible KafkaProducer version", e);
        }
    }

    private static Object getValue(Object object, String fieldName) {
        return ResumeTransactionUtil.getValue(object, object.getClass(), fieldName);
    }

    private static Object getValue(Object object, Class<?> clazz, String fieldName) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(object);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Incompatible KafkaProducer version", e);
        }
    }

    private static Object createProducerIdAndEpoch(long producerId, short epoch) {
        try {
            Field field = TransactionManager.class.getDeclaredField(PRODUCER_ID_AND_EPOCH_FIELD_NAME);
            Class<?> clazz = field.getType();
            Constructor<?> constructor = clazz.getDeclaredConstructor(Long.TYPE, Short.TYPE);
            constructor.setAccessible(true);
            return constructor.newInstance(producerId, epoch);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Incompatible KafkaProducer version", e);
        }
    }

    private static Object getTransactionManager(KafkaProducer kafkaProducer) {
        return ResumeTransactionUtil.getField(kafkaProducer, TRANSACTION_MANAGER_FIELD_NAME);
    }

    private static Object getField(Object object, String fieldName) {
        return ResumeTransactionUtil.getField(object, object.getClass(), fieldName);
    }

    private static Object getField(Object object, Class<?> clazz, String fieldName) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(object);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Incompatible KafkaProducer version", e);
        }
    }

    private static Enum<?> getTransactionManagerState(String enumName) {
        try {
            Class<?> cl = Class.forName(TRANSACTION_MANAGER_STATE_ENUM);
            return Enum.valueOf(cl, enumName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Incompatible KafkaProducer version", e);
        }
    }

    private static void transitionTransactionManagerStateTo(Object transactionManager, String state) {
        ResumeTransactionUtil.invoke(transactionManager, "transitionTo", ResumeTransactionUtil.getTransactionManagerState(state));
    }

    private static void setField(Object object, String fieldName, Object value) {
        ResumeTransactionUtil.setField(object, object.getClass(), fieldName, value);
    }

    private static void setField(Object object, Class<?> clazz, String fieldName, Object value) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(object, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Incompatible KafkaProducer version", e);
        }
    }
}

