/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.kafka;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.kafka.KafkaProcessors;
import com.hazelcast.jet.pipeline.Sources;
import com.hazelcast.jet.pipeline.StreamSource;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.apache.kafka.clients.consumer.ConsumerRecord;

public final class KafkaSources {
    private KafkaSources() {
    }

    @Nonnull
    public static <K, V> StreamSource<Map.Entry<K, V>> kafka(@Nonnull Properties properties, String ... topics) {
        return KafkaSources.kafka(properties, (FunctionEx & Serializable)r -> Util.entry(r.key(), r.value()), topics);
    }

    @Nonnull
    public static <K, V, T> StreamSource<T> kafka(@Nonnull Properties properties, @Nonnull FunctionEx<ConsumerRecord<K, V>, T> projectionFn, String ... topics) {
        Preconditions.checkPositive((double)topics.length, (String)"At least one topic required");
        return Sources.streamFromProcessorWithWatermarks((String)("kafkaSource(" + String.join((CharSequence)",", topics) + ")"), (boolean)true, (FunctionEx & Serializable)w -> KafkaProcessors.streamKafkaP(properties, projectionFn, w, topics));
    }
}

