/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.kinesis.impl.source;

import com.hazelcast.com.amazonaws.services.kinesis.AmazonKinesisAsync;
import com.hazelcast.com.amazonaws.services.kinesis.model.Record;
import com.hazelcast.com.amazonaws.services.kinesis.model.Shard;
import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.jet.core.EventTimePolicy;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.kinesis.impl.AwsConfig;
import com.hazelcast.jet.kinesis.impl.source.HashRange;
import com.hazelcast.jet.kinesis.impl.source.InitialShardIterators;
import com.hazelcast.jet.kinesis.impl.source.KinesisSourceP;
import com.hazelcast.jet.kinesis.impl.source.RangeMonitor;
import com.hazelcast.jet.kinesis.impl.source.ShardQueue;
import com.hazelcast.jet.retry.RetryStrategy;
import com.hazelcast.logging.ILogger;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class KinesisSourcePSupplier<T>
implements ProcessorSupplier {
    private static final long serialVersionUID = 2L;
    @Nonnull
    private final AwsConfig awsConfig;
    @Nonnull
    private final String stream;
    @Nonnull
    private final EventTimePolicy<? super T> eventTimePolicy;
    @Nonnull
    private final HashRange hashRange;
    @Nonnull
    private final RetryStrategy retryStrategy;
    @Nonnull
    private final InitialShardIterators initialShardIterators;
    @Nonnull
    private final BiFunctionEx<? super Record, ? super Shard, ? extends T> projectionFn;
    private transient int memberCount;
    private transient ILogger logger;
    private transient AmazonKinesisAsync client;

    public KinesisSourcePSupplier(@Nonnull AwsConfig awsConfig, @Nonnull String stream, @Nonnull EventTimePolicy<? super T> eventTimePolicy, @Nonnull HashRange hashRange, @Nonnull RetryStrategy retryStrategy, @Nonnull InitialShardIterators initialShardIterators, @Nonnull BiFunctionEx<? super Record, ? super Shard, ? extends T> projectionFn) {
        this.awsConfig = awsConfig;
        this.stream = stream;
        this.eventTimePolicy = eventTimePolicy;
        this.hashRange = hashRange;
        this.retryStrategy = retryStrategy;
        this.initialShardIterators = initialShardIterators;
        this.projectionFn = projectionFn;
    }

    public void init(@Nonnull ProcessorSupplier.Context context) {
        this.memberCount = context.memberCount();
        this.logger = context.logger();
        this.client = this.awsConfig.buildClient();
    }

    @Nonnull
    public Collection<? extends Processor> get(int count) {
        HashRange[] rangePartitions = this.rangePartitions(count);
        ShardQueue[] shardQueues = this.shardQueues(count);
        RangeMonitor rangeMonitor = new RangeMonitor(this.memberCount, this.client, this.stream, this.hashRange, rangePartitions, shardQueues, this.retryStrategy, this.logger);
        return IntStream.range(0, count).mapToObj(i -> new KinesisSourceP<T>(this.client, this.stream, this.eventTimePolicy, this.hashRange, rangePartitions[i], shardQueues[i], i == 0 ? rangeMonitor : null, this.retryStrategy, this.initialShardIterators, this.projectionFn)).collect(Collectors.toList());
    }

    private ShardQueue[] shardQueues(int count) {
        ShardQueue[] queues = new ShardQueue[count];
        Arrays.setAll(queues, IGNORED -> new ShardQueue());
        return queues;
    }

    private HashRange[] rangePartitions(int count) {
        HashRange[] ranges = new HashRange[count];
        Arrays.setAll(ranges, i -> this.hashRange.partition(i, count));
        return ranges;
    }

    public void close(@Nullable Throwable error) {
        if (this.client != null) {
            this.client.shutdown();
        }
    }
}

